#ifndef __PHONEMES_H__
#define __PHONEMES_H__

#define AA	40
#define AE	1
#define AH	2
#define AO	3
#define AW	4
#define AY	5
#define B	6
#define CH	7
#define D	8
#define DH	9
#define EH	10
#define ER	11
#define EY	12
#define F	13
#define G	14
#define HH	15
#define IH	16
#define IY	17
#define JH	18
#define K	19
#define L	20
#define M	21
#define N	22
#define NG	23
#define OW	24
#define OY	25
#define P	26
#define R	27
#define S	28
#define SH	29
#define T	30
#define TH	31
#define UH	32
#define UW	33
#define V	34
#define W	35
#define Y	36
#define Z	37
#define ZH	38

#define PSE 39

#define NUM_PHONEMES 39  // 39 + pause == 40

/*
 * Textual representation of phonemes.
 */
const unsigned char wAA[] = "AA";
const unsigned char wAE[] = "AE";
const unsigned char wAH[] = "AH";
const unsigned char wAO[] = "AO";
const unsigned char wAW[] = "AW";
const unsigned char wAY[] = "AY";
const unsigned char wB[] = "B";
const unsigned char wCH[] = "CH";
const unsigned char wD[] = "D";
const unsigned char wDH[] = "DH";
const unsigned char wEH[] = "EH";
const unsigned char wER[] = "ER";
const unsigned char wEY[] = "EY";
const unsigned char wF[] = "F";
const unsigned char wG[] = "G";
const unsigned char wHH[] = "HH";
const unsigned char wIH[] = "IH";
const unsigned char wIY[] = "IY";
const unsigned char wJH[] = "JH";
const unsigned char wK[] = "K";
const unsigned char wL[] = "L";
const unsigned char wM[] = "M";
const unsigned char wN[] = "N";
const unsigned char wNG[] = "NG";
const unsigned char wOW[] = "OW";
const unsigned char wOY[] = "OY";
const unsigned char wP[] = "P";
const unsigned char wR[] = "R";
const unsigned char wS[] = "S";
const unsigned char wSH[] = "SH";
const unsigned char wT[] = "T";
const unsigned char wTH[] = "TH";
const unsigned char wUH[] = "UH";
const unsigned char wUW[] = "UW";
const unsigned char wV[] = "V";
const unsigned char wW[] = "W";
const unsigned char wY[] = "Y";
const unsigned char wZ[] = "Z";
const unsigned char wZH[] = "ZH";

const unsigned char ph_AA_2bitDPCM[427]= {
0x07,0x00,0x04,0x0C,0x10,0xC0,0x10,0xC0,0x00,0x11,0xCC,0x0C,0x14,0x00,0x03,0xC1,
0x00,0x01,0x0C,0x10,0x30,0x10,0xC0,0x00,0x01,0x0C,0x01,0xCC,0x51,0x00,0xF3,0x40,
0xD1,0x30,0x10,0x0C,0x10,0xC0,0x00,0x01,0x03,0x04,0x0C,0x10,0xC0,0x10,0xC0,0x43,
0x15,0xF0,0x3F,0x48,0xC1,0x4F,0x04,0x03,0x41,0x33,0x10,0xC0,0x40,0x00,0x03,0x04,
0x30,0x44,0xFC,0x50,0x05,0xFC,0xCF,0x89,0xCD,0x4F,0x04,0x03,0x14,0xCF,0x11,0xCD,
0x1C,0xC5,0x3C,0x51,0x3C,0x50,0xF0,0x8F,0x25,0xF7,0xFF,0x63,0x3A,0xFF,0x54,0xF3,
0x51,0xF0,0x43,0x05,0xCF,0x51,0xF0,0x43,0xD1,0x03,0x15,0xFF,0xA3,0xF6,0xFC,0xFF,
0x96,0xCE,0x3F,0xD5,0x7C,0x14,0xFC,0x50,0xC1,0x0F,0x15,0xFC,0x50,0xC1,0x4F,0xD6,
0xFF,0xA3,0xFA,0xFF,0xFF,0xA9,0xF1,0xFF,0x16,0x3F,0x15,0xFC,0x50,0xC4,0x3C,0x51,
0xF0,0x43,0x01,0x4F,0x18,0xFC,0x9F,0xD6,0xF3,0xFF,0x5B,0xCA,0xFF,0x1B,0x3D,0x40,
0x34,0x73,0x04,0x30,0x13,0x11,0xCF,0x11,0xC0,0x53,0xC2,0xFF,0xAB,0xF2,0xCF,0xFF,
0xA5,0xF2,0xFF,0x49,0x3C,0x10,0xC0,0x00,0x04,0x30,0x00,0x01,0x30,0x40,0xC0,0x1C,
0x09,0xFF,0xA3,0xD5,0x3F,0xCF,0x87,0xD6,0xFF,0x27,0xF1,0x40,0x00,0x0C,0x40,0x00,
0x03,0x10,0x00,0x03,0x04,0xCC,0x54,0xC1,0xFF,0xA8,0x3D,0xCF,0xFF,0xA2,0xF2,0xFF,
0x46,0x33,0x10,0x00,0x03,0x10,0xC0,0x00,0x04,0xC0,0x00,0x01,0x03,0x44,0xFD,0x0F,
0x5A,0xFC,0xF7,0x7C,0x65,0xF0,0x4F,0x04,0x30,0x10,0xC0,0x00,0x04,0xC0,0x00,0x01,
0xC0,0x00,0x01,0x73,0x54,0xFC,0x4F,0x8A,0xCF,0xF3,0x7C,0x68,0xF0,0xBF,0xD4,0x30,
0x10,0x00,0x03,0x10,0xC0,0x00,0x04,0xC0,0x00,0x01,0x0C,0x10,0x01,0xFF,0x65,0xF4,
0x0C,0xFF,0x85,0xC5,0x3F,0x44,0x00,0x03,0x10,0xC0,0x00,0x04,0x30,0x00,0x01,0x0C,
0x10,0x00,0x0C,0x10,0x35,0xFF,0xA4,0xF4,0x7C,0xCF,0x97,0xC5,0x3F,0x50,0x00,0x0C,
0x00,0x01,0x0C,0x40,0x00,0x03,0x04,0xC0,0x00,0x01,0x30,0x00,0x44,0xF0,0x1F,0x49,
0x3C,0xC7,0x3C,0x61,0xC0,0x0F,0x11,0x00,0x0C,0x40,0x00,0x03,0x10,0xC0,0x00,0x01,
0x30,0x40,0x00,0x0C,0x00,0x11,0xF0,0x1F,0x46,0x3C,0xC7,0x3C,0x55,0xCD,0x0F,0x11,
0x00,0x0C,0x40,0x00,0x03,0x10,0xC0,0x00,0x04,0xC0,0x00,0x01,0x30,0x00,0x04,0x31,
0x0F,0x15,0x3D,0x1C,0xF3,0x51,0xC1,0xCC,0x44,0x00,0x30,0x00,0x01,0x30,0x00,0x01,
0x30,0x40,0x00,0x0C,0x40,0x00,0x0C,0x00,0x41,0xCC,0x43,0x08,0x3D,0xD3,0x30,0x50,
0xC1,0x33,0x41,0x00,0x30,0x00,0x04,0x30,0x00,0x01,0xC0};

const unsigned char ph_AE_2bitDPCM[391]= {
0x08,0xC0,0x40,0x00,0x00,0x30,0x34,0x01,0x13,0x57,0xFC,0xFD,0xD5,0xC4,0x40,0x1C,
0x0C,0x00,0x00,0x01,0x0C,0x04,0x30,0x40,0x00,0x00,0x30,0x74,0xD0,0x2F,0x97,0xFC,
0xFC,0xD5,0xF8,0x47,0x1C,0x0C,0x00,0x00,0x01,0x0C,0x04,0x30,0x40,0x00,0x00,0x30,
0x74,0xD0,0x13,0x97,0xFC,0xFC,0xD5,0xF8,0x47,0x1C,0x0C,0x00,0x00,0x01,0x03,0x04,
0x30,0x40,0x00,0x00,0x0C,0x74,0xC4,0xE3,0x9B,0x3F,0xFF,0xC9,0xF5,0x47,0x07,0x0C,
0x00,0x40,0x00,0x03,0x04,0x30,0x10,0x00,0x00,0x0C,0x4D,0xF4,0xCB,0x25,0x7F,0x3F,
0x35,0xFE,0x11,0x07,0x03,0x00,0x40,0x00,0x03,0x01,0x0C,0x10,0x00,0x00,0x0C,0x4D,
0xF4,0xCB,0x25,0x7F,0x3F,0x35,0xFE,0x11,0x07,0x03,0x00,0x00,0x01,0x03,0x04,0x0C,
0x10,0x00,0x00,0x0C,0x4D,0xF4,0xCB,0x55,0x7F,0xFF,0xC9,0xF5,0x47,0x07,0x0C,0x00,
0x00,0x01,0x03,0x04,0x30,0x10,0x00,0x00,0x0C,0x74,0xF4,0xE7,0x5B,0x7F,0xFF,0xC9,
0xF5,0x47,0x13,0x0C,0x00,0x00,0x01,0x03,0x04,0x30,0x10,0x00,0xC0,0x00,0x1D,0xC0,
0x34,0xD9,0x0F,0x7F,0x35,0xF1,0x11,0x07,0x30,0x00,0x40,0x30,0x40,0x00,0x0C,0x01,
0x00,0x0C,0xD0,0x14,0x4F,0x5C,0xF2,0xF3,0x57,0x13,0x4F,0x71,0x00,0x03,0x00,0x04,
0x03,0x04,0xC0,0x10,0x00,0xC0,0x00,0x1D,0xC0,0xC4,0xE5,0x0F,0x7F,0x35,0xF1,0x11,
0x07,0x30,0x00,0x40,0x30,0x00,0x01,0x0C,0x01,0x00,0x0C,0xD0,0x14,0xBF,0x8C,0xF5,
0xF7,0x9F,0x1C,0x3C,0xC5,0x01,0x03,0x00,0x04,0x0C,0x10,0xC0,0x40,0x00,0x00,0x03,
0x34,0x01,0x13,0x57,0xFC,0xFE,0x14,0x07,0x1F,0x4D,0xC0,0x00,0x00,0x01,0x03,0x04,
0x30,0x10,0x00,0x30,0x40,0x53,0x3C,0xF8,0xD6,0xDF,0x7F,0x32,0xF1,0x14,0x07,0x30,
0x00,0x10,0x03,0x40,0x00,0x30,0x01,0x00,0x03,0x34,0x01,0x13,0x57,0xFC,0xFE,0x14,
0x07,0x73,0x4D,0x00,0x03,0x00,0x0D,0x00,0x01,0x00,0x00,0x00,0x0C,0xD0,0xC8,0x4C,
0x5C,0xF2,0xF7,0x6F,0x1C,0x3C,0xC5,0x01,0x0C,0x00,0x00,0x00,0x04,0x00,0x00,0x00,
0x30,0x10,0xD7,0x0C,0x71,0xC5,0xDF,0x5F,0x71,0x30,0x17,0x07,0x30,0x00,0x00,0x00,
0x10,0x00,0x00,0x00,0xC0,0x40,0x5C,0x3C,0xC4,0x15,0xBF,0xFF,0xC9,0xC4,0x5C,0x1C,
0xC0,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x00,0x03,0x71,0xCD,0x10,0x57,0xFC,0xFD,
0x15,0x07,0x73,0x71,0x00,0x03,0x00};

const unsigned char ph_AH_2bitDPCM[433]= {
0x08,0x00,0x13,0x4C,0xC0,0x10,0x03,0x01,0x1C,0x03,0x05,0x4F,0x33,0x08,0x4C,0x0C,
0x04,0x4C,0x30,0x10,0x4C,0x0C,0x04,0x1C,0x0C,0xC1,0x10,0x03,0x01,0x4C,0x03,0xD5,
0x73,0xCF,0x15,0x4C,0x0C,0x10,0x4C,0x30,0x10,0x0C,0x00,0x01,0x07,0x43,0x30,0x10,
0x43,0x00,0xD3,0xB0,0xF6,0xDF,0x7F,0x3A,0x1C,0x73,0x04,0x4C,0x30,0x04,0x43,0x03,
0xC1,0xC1,0x10,0x30,0xC4,0x10,0xCD,0xC4,0x9C,0xFE,0xC7,0x4F,0x36,0xD3,0x4C,0x01,
0x13,0x0C,0xC4,0xD0,0x40,0xC0,0xC1,0x10,0x0C,0x31,0x50,0xCC,0x34,0xA3,0xFE,0xF7,
0xBF,0xC6,0xC7,0x4C,0xC1,0x04,0x0C,0xC1,0x00,0x40,0xC0,0xC1,0x04,0x0C,0x31,0x50,
0xCC,0xF1,0xA0,0xFE,0xF7,0x8F,0xF2,0xC4,0x43,0xC1,0x04,0x03,0x31,0x00,0x10,0x00,
0x30,0x04,0x0C,0x31,0x1B,0x3C,0xFE,0xAB,0xFD,0xFC,0xAF,0xF1,0x31,0x53,0xC0,0x04,
0x43,0x30,0x34,0x10,0x70,0x30,0x01,0x43,0x0C,0x08,0x4F,0x3C,0x69,0xFF,0xFC,0xA7,
0x3C,0xCD,0x14,0x30,0xC1,0x40,0x0C,0x0D,0x04,0x1C,0x0C,0x01,0x43,0x0C,0x05,0x8F,
0xFF,0x6A,0x3F,0xFF,0x6B,0x7C,0xCC,0x14,0x0C,0xC1,0x10,0x0C,0x0D,0x04,0x4C,0x30,
0x01,0x43,0x0C,0x05,0x4F,0x3C,0xEA,0x3F,0xFF,0x68,0x73,0xCC,0x14,0x30,0xC1,0x10,
0x0C,0x0D,0x04,0x1C,0x30,0x01,0x43,0x0C,0x05,0x4F,0x0F,0xEA,0x7F,0xFF,0x6B,0x7C,
0xCC,0x14,0x4C,0x30,0x10,0x03,0x0D,0x04,0x13,0x4C,0xC0,0x10,0x43,0x31,0xD3,0x8C,
0xFA,0xDF,0x3F,0xCA,0x13,0x33,0x05,0x13,0x0C,0x04,0x03,0x40,0x00,0x30,0x04,0x43,
0x0C,0x14,0x73,0x3C,0xA8,0xFF,0xFD,0xA3,0x3C,0xF1,0x20,0x30,0xC1,0x40,0x30,0x00,
0x01,0xC0,0x10,0x30,0xC4,0x50,0xCC,0xC4,0x93,0xF2,0xC3,0xBF,0x36,0xC7,0x4C,0xC1,
0x04,0x0C,0xC1,0x00,0x10,0x70,0x30,0x01,0x43,0x0C,0x05,0x4F,0x33,0xEA,0x3F,0xFF,
0x68,0x73,0xCC,0x14,0x4C,0x30,0x10,0x43,0x0C,0x01,0x07,0x13,0x30,0xC4,0x40,0xF1,
0xC4,0x9C,0xF2,0xC3,0xBF,0x36,0xC7,0x4C,0xC1,0x10,0x0C,0x31,0xC4,0x10,0x70,0x30,
0x01,0x43,0x0C,0x14,0x4F,0xCC,0x29,0x3F,0xFC,0x6B,0x73,0xCC,0x14,0x4C,0x30,0x10,
0x4C,0x03,0x01,0xC0,0x04,0x0C,0xC1,0x50,0x33,0x31,0xA7,0xCF,0xF0,0x93,0xCD,0x31,
0x47,0x0C,0xC1,0x40,0x30,0x00,0x04,0x00,0x13,0x30,0x04,0x53,0xCC,0x34,0xAC,0xFD,
0xF7,0xAF,0xCD,0xC4,0x1C,0x31,0x04,0x03,0x31,0x00,0x04,0x00,0x13,0x30,0x04,0x13,
0xCD,0x34,0x6C,0xF1,0xF7,0x8C,0x01,0xC7,0x00,0x31,0x04,0x03,0x31,0x00,0x04,0x00,
0x4C,0xC0,0x10,0x4C,0xC0,0xD0,0x80,0x31,0xC3,0x4F,0x02,0x07,0x03,0x31,0x04,0x03,
0x31};

const unsigned char ph_AO_2bitDPCM[403]= {
0x08,0x0C,0x04,0x0C,0x01,0x33,0x15,0xFC,0x67,0xF1,0xDC,0x3C,0x59,0xFF,0x57,0x31,
0x03,0xC1,0x10,0x30,0x10,0x30,0x10,0x30,0x01,0x33,0x55,0xFC,0xAF,0xF2,0x1F,0xFF,
0xA9,0xFF,0x6F,0x31,0x03,0x34,0x10,0x30,0x40,0x00,0x03,0x01,0x07,0x30,0x53,0xF2,
0x7F,0xDA,0xF3,0xFE,0xAF,0xF6,0x3F,0x15,0x33,0x00,0x40,0xC0,0x00,0x04,0x30,0x40,
0x00,0x00,0x33,0x65,0xFF,0xAF,0xF6,0x0F,0xFF,0xA9,0xFC,0x4F,0x32,0x03,0x00,0x04,
0x30,0x40,0x07,0x30,0x10,0x00,0xC0,0x70,0x15,0xFF,0xA7,0x3D,0xEF,0xFF,0x6A,0xFF,
0x53,0x31,0x03,0x00,0x04,0x0C,0x04,0x43,0xC0,0x40,0x00,0x00,0x33,0x95,0xFF,0xAF,
0xF6,0xBF,0xFF,0xAB,0xFD,0x4F,0xC5,0x0C,0x00,0x04,0x0C,0x10,0x30,0x10,0x30,0x10,
0x00,0x30,0x4C,0x09,0xFF,0x98,0xFC,0xC7,0x7F,0x2A,0xFF,0x47,0x0D,0x03,0x00,0x01,
0x03,0x04,0x0C,0x04,0x30,0x10,0x00,0x30,0x8C,0xD8,0xFF,0xAB,0xFD,0xF7,0x7F,0x2A,
0xFF,0x53,0x0D,0x03,0x00,0x01,0x03,0x04,0x0C,0x10,0x30,0x40,0x00,0xC0,0x70,0x15,
0xFF,0x6B,0xFD,0xC7,0x3C,0x69,0xFF,0x53,0x0D,0x03,0x00,0x01,0x03,0x04,0x30,0x10,
0xC0,0x40,0x00,0xC0,0x30,0x56,0xFF,0xA3,0xF1,0xEF,0xFF,0xA9,0xFC,0x4F,0x35,0xDC,
0x00,0x04,0x0C,0x10,0xC0,0x40,0x00,0x03,0x04,0x70,0x03,0x57,0xF1,0xBF,0xD6,0x3F,
0xFE,0x93,0xF6,0x3F,0xE1,0x00,0x0C,0x10,0xC0,0x00,0x01,0x0C,0x10,0xC0,0x00,0x01,
0x0C,0xC0,0x55,0xFC,0x9F,0xC6,0x7F,0xCC,0x93,0xF6,0x3F,0x05,0x00,0xCC,0x11,0xC0,
0x00,0x01,0x30,0x40,0x00,0x03,0x04,0xC0,0x00,0x10,0xF5,0x3F,0x5A,0xFF,0xF8,0xBF,
0x19,0xFF,0x44,0x00,0xC0,0x1C,0x01,0x0C,0x10,0x00,0x03,0x04,0xC0,0x1C,0xC5,0x0C,
0x00,0x14,0xFD,0x9F,0xC6,0x7F,0xCC,0x93,0xF6,0x3F,0x11,0x00,0xCC,0x44,0x31,0x73,
0x04,0xC0,0x00,0x01,0x30,0x40,0x31,0x03,0x00,0x11,0xFF,0xA4,0xF1,0x1F,0xF3,0xA4,
0xFC,0x43,0x04,0x00,0x33,0x11,0xCD,0x00,0x01,0x30,0x00,0xD1,0xCC,0x44,0x31,0x03,
0x00,0x45,0xFF,0xA7,0xF1,0x5F,0xF3,0xA3,0xF1,0x0F,0x05,0x00,0xCC,0x44,0x31,0x73,
0x10,0xC0,0x00,0x04,0xC0,0x00,0x11,0x33,0x00,0x1D,0x34,0x7F,0x16,0xCF,0x38,0x3F,
0x19,0xFC,0x04,0x10,0x00,0x73,0x04,0xC0,0x00,0x04,0x30,0x00,0x01,0x30,0x00,0x05,
0xCF,0x41,0x1C,0xF4,0x03,0x4A,0xFF,0x38,0x3F,0x19,0xFC,0x41,0x13,0x00,0x73,0x04,
0xC0,0x00,0x04};

const unsigned char ph_AW_2bitDPCM[561]= {
0x08,0x00,0xC0,0x50,0xF0,0x34,0x53,0xCD,0x00,0x10,0x30,0x10,0xC0,0x40,0x00,0x03,
0x01,0x0C,0x04,0x30,0x10,0x00,0x03,0x05,0x4F,0x33,0xD5,0x0C,0x00,0x01,0x03,0x01,
0x0C,0x04,0x30,0x10,0xC0,0x40,0x34,0x1F,0x01,0xF4,0xA3,0xFC,0xF4,0x93,0xCD,0x00,
0x50,0xFC,0x14,0xC0,0x40,0x00,0x03,0x01,0x0C,0x50,0xFC,0x14,0x00,0xCC,0x19,0x7F,
0xFC,0x28,0x33,0x00,0x14,0x3F,0x05,0x30,0x40,0xC0,0x00,0x01,0x0C,0x44,0xFC,0x54,
0x30,0xFD,0x68,0xFF,0xFE,0x67,0x3C,0x0C,0xE5,0x3F,0x14,0xCD,0x53,0x00,0x03,0x04,
0x0C,0x10,0xF1,0x5F,0xC2,0xF4,0xA3,0xFE,0xF7,0xBF,0xC6,0xC3,0x60,0xFD,0x13,0xC5,
0x3C,0x45,0x33,0x47,0x31,0x4F,0x51,0xFF,0x2B,0x70,0xFF,0x2A,0x7F,0xFC,0x67,0x3C,
0x0C,0x19,0xFF,0x54,0xF0,0x43,0xD1,0x0C,0x44,0x3C,0x53,0x04,0x3F,0x09,0x0C,0x73,
0xCA,0x4F,0xFF,0xE8,0x0C,0x43,0xC9,0x3F,0x51,0xCC,0x13,0x01,0x33,0x45,0xFC,0x50,
0x01,0xFF,0x26,0x7F,0x0F,0xEA,0xBF,0xFF,0x2B,0x7C,0x3F,0xDA,0xFC,0x50,0xC1,0x4F,
0x44,0x33,0x40,0x34,0x4F,0x14,0xF0,0x6F,0xC1,0x37,0xAC,0xFE,0xC7,0x7F,0x02,0xC7,
0x9F,0xC1,0x0F,0x51,0xCC,0x13,0x01,0xCC,0x11,0xF1,0x4C,0x11,0xFC,0x67,0xCD,0x37,
0xA0,0xFD,0xFB,0xBF,0xDE,0xFB,0x9F,0xCE,0x0F,0x45,0x3C,0x13,0xD1,0x0C,0x10,0xCD,
0x1C,0x11,0xF3,0x60,0xFD,0x34,0xA0,0xFC,0xFB,0x8F,0x01,0xF7,0x50,0xC1,0x0F,0x45,
0x3C,0x00,0x01,0x0C,0x10,0xCD,0x1C,0x05,0xF3,0x67,0xFD,0x34,0xA0,0xFC,0xFB,0xBF,
0x02,0xF7,0x93,0xC1,0x0F,0x51,0xCC,0x13,0x01,0x0C,0x10,0xC0,0x70,0x14,0xF3,0x50,
0xC1,0xD3,0x80,0xF2,0xEF,0x3F,0x06,0xD0,0x7F,0x06,0xCF,0x44,0x34,0x03,0x10,0xC0,
0x00,0xD1,0xF0,0x44,0xC1,0x3C,0x64,0xFC,0x00,0x64,0xFC,0xFB,0x8F,0x01,0xF4,0x9F,
0xC1,0x33,0x44,0x31,0x03,0x04,0xC0,0x00,0x01,0x30,0x40,0xC4,0xCC,0x54,0xFD,0x07,
0x90,0xFD,0xD7,0x3F,0x06,0xD7,0x0F,0x06,0x33,0x13,0x01,0x0C,0x40,0x00,0x03,0x10,
0xC0,0x00,0x14,0x3C,0x43,0xC5,0x4C,0x43,0xC9,0xBF,0xFC,0x27,0x70,0xCC,0x54,0x30,
0x73,0x10,0xC0,0x00,0x01,0x30,0x40,0x00,0x0C,0x10,0x00,0x33,0x45,0xCC,0x34,0x60,
0xFC,0x0B,0x7F,0x05,0xC7,0x70,0x14,0x33,0x00,0x01,0x0C,0x40,0x00,0x0C,0x10,0x00,
0x03,0x04,0xC0,0x4C,0x11,0xC3,0x70,0x18,0xFF,0xF6,0x8F,0xC5,0x30,0x4C,0x14,0x33,
0x00,0x01,0x0C,0x40,0x00,0x0C,0x10,0x00,0x03,0x04,0xC0,0x00,0x01,0x00,0xC3,0x15,
0xFD,0xC4,0x7C,0x45,0xC3,0x00,0x40,0x00,0x03,0x10,0xC0,0x00,0x04,0xC0,0x00,0x01,
0x30,0x00,0x01,0x0C,0x40,0x00,0x30,0x4C,0xD5,0x33,0x31,0x5F,0xC5,0x30,0x00,0x10,
0xC0,0x00,0x04,0x30,0x00,0x01,0x30,0x40,0x00,0x0C,0x40,0x00,0x03,0x10,0x00,0x30,
0x5C,0xC1,0x30,0x0D,0x43,0x01,0x0C,0x00,0x04,0xC0,0x00,0x04,0x30,0x00,0x01,0x30,
0x40,0x00,0x0C,0x40,0x00,0x03,0x10,0x00,0xC0,0x4C,0x05,0xCC,0x34,0x0C,0x45,0xC3,
0x00,0x00,0x01,0x0C,0x40,0x00,0x0C,0x40,0x00,0x0C,0x10,0x00,0x03,0x10,0x00,0x03,
0x10,0x00,0xC0,0x00,0x11,0x0C,0xC7,0x30,0x14,0x00,0x03,0x00,0x04,0xC0,0x00,0x04,
0xC0,0x00,0x04,0xC0,0x00,0x04,0x00,0x03,0x10,0x00,0x03,0x04,0x00,0xC0,0x4C,0x14,
0x30,0xD3,0x30,0x50,0xC4,0x0C,0x00,0x10,0x00,0x03,0x10,0x00,0x03,0x10,0x00,0x1C,
0x00};

const unsigned char ph_AY_2bitDPCM[561]= {
0x07,0x00,0x04,0x0C,0x04,0x30,0x40,0x00,0xCC,0x09,0x73,0x33,0xD8,0x0C,0x40,0x00,
0x03,0x04,0x0C,0x10,0x30,0x10,0xC0,0x40,0x00,0x03,0x04,0xC0,0x6C,0xF0,0x34,0x83,
0xCD,0x07,0x04,0x30,0x10,0xC0,0x40,0x00,0x03,0x01,0x0C,0x44,0xF3,0x41,0x10,0x3F,
0xCA,0x4F,0x3F,0x19,0x3F,0x41,0xC4,0x4F,0x01,0x0C,0x10,0x30,0x10,0xC0,0x00,0xC5,
0x73,0x04,0xC4,0x8F,0xF2,0xD3,0x4F,0xC6,0x1F,0x10,0xF1,0x13,0x35,0x03,0x04,0xCC,
0x11,0xCD,0x53,0xC1,0xBF,0x44,0xC0,0x8F,0xF6,0xEF,0x3F,0x0A,0x3F,0x44,0xF2,0x4F,
0x05,0x3F,0x51,0x3C,0x47,0x31,0x4F,0x05,0xFF,0x15,0x01,0xFF,0xEA,0xBF,0xFF,0x6B,
0xFC,0x40,0xD8,0xFF,0x55,0xCC,0x53,0xC4,0x0F,0x15,0xFC,0x60,0xF1,0xBF,0x05,0xF7,
0xAF,0xF2,0xD3,0x3F,0xDA,0xCF,0x50,0xF2,0x4F,0x05,0x3F,0x54,0xF0,0x53,0xC4,0x33,
0x15,0xFD,0x23,0x31,0xF0,0xA4,0xFC,0xF4,0x8F,0xC2,0x33,0x94,0xFC,0x13,0xC5,0x3C,
0x51,0x3C,0x53,0xC1,0x0F,0x15,0xFD,0x6F,0xC1,0xF0,0xA0,0xFD,0xFB,0xBF,0xC6,0xF7,
0x97,0xF1,0x0F,0x15,0xFC,0x50,0x31,0x4F,0x14,0xF3,0x50,0xC1,0x3F,0x0A,0x4F,0x1F,
0xCA,0xBF,0xFC,0x27,0x7D,0x3C,0xE8,0xFC,0x50,0xC4,0x33,0x45,0xCC,0x13,0x05,0x3F,
0x54,0xC0,0x7F,0xD6,0x0F,0x47,0xF6,0x9F,0xFF,0x1B,0x1C,0x7F,0xD9,0xFC,0x50,0xC1,
0x0F,0x45,0x3C,0x53,0xC4,0x3C,0x51,0xF0,0x43,0x05,0x0F,0x40,0xF2,0x6F,0xFF,0x09,
0x1C,0x0F,0x06,0x3F,0x44,0x31,0x4F,0x44,0x33,0x53,0xC4,0x33,0x45,0xF0,0xB3,0xD2,
0x0F,0x40,0xF6,0x2F,0xFF,0x09,0x00,0x0F,0x06,0xCF,0x50,0x31,0x4F,0x44,0x3C,0x40,
0xD0,0x3C,0x51,0xCC,0x0C,0x12,0x0F,0xD0,0xC6,0xBF,0xFC,0xD8,0x01,0x3C,0xD5,0xCD,
0x43,0xD1,0x0C,0x40,0x00,0x03,0x44,0x3C,0x13,0x05,0x3F,0x5D,0xF5,0x03,0xB1,0xF1,
0xD7,0x7F,0x4E,0xC4,0x1F,0x41,0xFC,0x50,0xC4,0xCC,0x11,0x00,0x03,0x04,0xC0,0x00,
0x11,0xCF,0x44,0x04,0x0F,0x35,0xC1,0x2F,0x0F,0x35,0xD1,0x4F,0x44,0xCC,0x1C,0x04,
0x30,0x40,0x00,0x0C,0x10,0x00,0x03,0x44,0xCC,0x13,0x41,0x3C,0xE0,0x4B,0x3F,0xFE,
0x10,0x0B,0x3C,0x41,0xC4,0xC3,0x11,0xC0,0x00,0x04,0x30,0x00,0x01,0x0C,0x40,0x00,
0xCC,0x11,0x34,0x03,0xB1,0xF4,0xC7,0x03,0x4E,0x30,0xC0,0x05,0xC0,0x00,0x01,0x30,
0x40,0x00,0x0C,0x10,0x00,0x03,0x04,0x30,0x00,0xD4,0xC0,0x8C,0x10,0xCD,0xF0,0x47,
0x20,0x0F,0x70,0x01,0xC0,0x00,0x04,0x30,0x40,0x00,0x0C,0x10,0xC0,0x00,0x01,0x30,
0x40,0x1C,0x30,0x70,0x41,0x34,0xF3,0xD0,0x51,0x03,0x03,0x40,0x00,0x30,0x00,0xC1,
0x00,0x10,0x30,0x10,0x00,0xC0,0x01,0x30,0xD0,0x04,0x00,0x03,0x2C,0x41,0x33,0x3C,
0xD0,0x39,0xCD,0x0D,0x00,0x04,0x00,0x30,0x00,0x00,0x01,0x0C,0x10,0x00,0xC0,0x00,
0x10,0x07,0x00,0x0C,0x5C,0x47,0x1C,0x7C,0x4F,0x13,0x5D,0x03,0x0C,0x00,0x40,0x00,
0x00,0x03,0x00,0xD0,0x34,0x01,0x00,0x0C,0x00,0x40,0x00,0x00,0x0C,0x8C,0x1C,0x71,
0x30,0x3C,0xDD,0x75,0x0D,0x0C,0x00,0x00,0x01,0x00,0x0C,0x00,0x10,0xC0,0x00,0x01,
0x00,0x0C,0x00,0x40,0x00,0x00,0x0C,0x40,0x1C,0x71,0x30,0x3C,0x1D,0x74,0x0D,0x0C,
0x00,0x00,0x01,0x00,0x0C,0x00,0x40,0x00,0x0C,0x40,0x00,0x00,0x0C,0x00,0x40,0x00,
0x00,0x0C,0x5C,0x1C,0x71,0x30,0x3C,0xD0,0x75,0x0D,0x0C,0x00,0x40,0x00,0x00,0x0C,
0x00};

const unsigned char ph_B_2bitDPCM[159]= {
0x08,0x00,0x30,0x4D,0xD3,0x04,0x00,0x00,0x00,0x00,0xC0,0x00,0x00,0x00,0x00,0x00,
0x1D,0x4C,0x0C,0xC1,0xC4,0x40,0x4C,0xC0,0x34,0x10,0x1C,0x00,0x00,0x00,0x00,0x0C,
0x4C,0x10,0x0C,0x04,0x03,0x01,0x0C,0x04,0x0C,0x10,0x30,0x10,0xC0,0x40,0x00,0x13,
0x30,0x50,0x00,0xDF,0x03,0x05,0x0C,0xC4,0x00,0x01,0x03,0x04,0x0C,0x04,0x30,0x10,
0xC0,0x40,0x00,0x07,0x30,0x50,0x30,0x37,0x43,0x01,0x03,0x31,0x10,0x30,0x00,0x10,
0x0C,0x01,0x43,0xC0,0x10,0x03,0x01,0x43,0x0C,0x08,0x73,0xCC,0x14,0x30,0x31,0x40,
0x30,0xC1,0x40,0x0C,0x34,0xC1,0x10,0x30,0xC4,0x10,0xC0,0xC4,0x40,0xC1,0xC7,0x43,
0x01,0x13,0x03,0x01,0x13,0x0C,0xC4,0x40,0x4C,0x30,0x04,0x0C,0x0D,0x04,0x30,0x31,
0x5B,0xFC,0x3D,0x63,0xC0,0x31,0x40,0xC0,0xC1,0x40,0x30,0x10,0x13,0x0C,0x01,0x43,
0x0C,0x04,0x4C,0xCC,0x19,0xF3,0xFD,0x64,0x33,0x31,0x17,0x30,0xC1,0x40,0x30};

const unsigned char ph_CH_2bitDPCM[177]= {
0x07,0x74,0xDC,0x01,0x00,0xC0,0x71,0x00,0x00,0x77,0xD3,0x71,0x77,0x1C,0x07,0x00,
0x70,0x00,0x00,0x70,0x37,0x4D,0x77,0xDC,0x71,0x77,0x1C,0x00,0x00,0x77,0xDC,0x71,
0xC7,0x1D,0x70,0x00,0xDC,0x71,0x37,0xDD,0x71,0xC7,0x01,0x70,0xC0,0x01,0x70,0x1C,
0x37,0x71,0x00,0xDC,0x74,0x1C,0x70,0x13,0x13,0x07,0x00,0x37,0xC1,0x01,0x70,0xC7,
0x4D,0x07,0xC0,0x74,0xC7,0x01,0x70,0xC7,0x01,0x70,0x00,0x00,0xC7,0x31,0x4D,0x13,
0xC7,0x34,0x4D,0x1C,0x07,0xC7,0x71,0x1C,0xC7,0x74,0x1C,0x00,0xC7,0x4D,0x07,0x1C,
0x13,0xD3,0xDD,0x71,0x1C,0x00,0xC7,0x71,0x1C,0xC7,0x71,0x70,0x4C,0xC7,0x01,0x77,
0xC7,0x74,0x00,0xC0,0x71,0x37,0x1D,0x1C,0x70,0xC7,0x1D,0x07,0x1C,0x70,0xC0,0x71,
0x1C,0x1C,0x07,0x07,0xC0,0x31,0x4D,0x70,0xD3,0x1D,0x07,0xC0,0x4D,0xC7,0xC1,0x71,
0xDC,0x01,0x1C,0xC7,0x74,0x1C,0x1C,0x07,0x00,0xC7,0xC1,0x71,0x70,0x1C,0x13,0xC0,
0x01,0x00,0x00,0x1C,0x07,0xC0,0x01,0x1C,0x13,0x07,0x00,0x00,0x1C,0x00,0x70,0x00,
0x00};

const unsigned char ph_D_2bitDPCM[159]= {
0x08,0x4C,0x07,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x34,0x00,0x00,0x00,0x00,
0x00,0xD0,0x00,0x00,0x31,0xC4,0xC4,0x74,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x34,0xD0,0x04,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x37,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0xC7,0xD0,0x00,0x00,
0x00,0x00,0x04,0xD0,0x04,0x03,0xDC,0x00,0x43,0x13,0x40,0x00,0x00,0x00,0x00,0x03,
0x04,0xC0,0x00,0x00,0x00,0x00,0x01,0x74,0x00,0xC7,0x30,0x0C,0x34,0x71,0x01,0x00,
0x00,0x30,0x00,0x00,0x01,0x00,0x30,0x00,0x00,0x00,0xC4,0x72,0x00,0xF7,0x3E,0x03,
0x74,0x4D,0x00,0x00,0x00,0x03,0x00,0x00,0x01,0x00,0x00,0x03,0x07,0x07,0xE0,0x38,
0x34,0xC7,0x3D,0x73,0x70,0x4E,0x40,0x43,0x03,0x03,0x00,0x00,0x04,0x00,0x00,0x30,
0x00,0x4C,0xB0,0x2C,0x10,0x43,0xCF,0xCC,0x01,0x38,0x0E,0x0D,0x00,0xD3,0x00};

const unsigned char ph_DH_2bitDPCM[153]= {
0x08,0x0C,0x04,0x30,0x00,0x00,0x01,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0xD0,0x74,
0x00,0xC0,0x00,0x01,0x00,0x03,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x0C,0x00,0x00,
0x00,0x0D,0x01,0xC0,0x40,0x43,0xC0,0x10,0x0C,0x00,0x00,0x01,0x00,0x00,0x00,0x30,
0x00,0x00,0x00,0x00,0x01,0x00,0x70,0xD3,0xDD,0x1D,0xD3,0x0D,0x00,0x10,0x00,0x00,
0x00,0x00,0x03,0x00,0x00,0x00,0x10,0x00,0x00,0x4C,0xC7,0x01,0x4C,0x07,0x30,0x00,
0x10,0x00,0x00,0x00,0x00,0x0C,0x00,0x00,0x00,0x40,0x00,0xDC,0x01,0x03,0x71,0x00,
0xD3,0xDD,0x00,0x00,0x01,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x00,0xC1,0x01,0x07,
0x30,0x40,0xC0,0x4D,0x77,0x37,0x00,0x10,0x1C,0x00,0x00,0x00,0x0C,0x00,0x00,0x00,
0x10,0x07,0x00,0xDC,0x40,0x1C,0xC0,0x40,0xC0,0x40,0x43,0x30,0x04,0x00,0x00,0x00,
0x03,0x00,0x00,0x40,0x13,0xC7,0x71,0xDC,0x34};

const unsigned char ph_EH_2bitDPCM[381]= {
0x07,0x04,0x07,0x00,0x4C,0x43,0x07,0x30,0xBD,0x10,0xF1,0xFC,0x11,0xC8,0xC7,0x40,
0x13,0xDC,0x0D,0x00,0xD0,0xD0,0x01,0x00,0xD3,0xD0,0x04,0x4C,0x2F,0x44,0x3C,0xFC,
0x11,0xF9,0x30,0xD0,0x04,0x77,0x03,0x00,0xC1,0x40,0x00,0xC0,0x0D,0x10,0x07,0x0C,
0x8C,0x44,0xF1,0xFC,0x47,0xD8,0xC3,0x40,0x13,0xC7,0x0D,0x00,0x10,0x0C,0x01,0x00,
0xDC,0x34,0x74,0x00,0xD3,0x4B,0x14,0xCF,0x7F,0xB4,0x3E,0x0C,0x34,0x31,0xC1,0x00,
0x00,0x01,0x43,0x00,0x00,0x03,0x0D,0x8D,0xF0,0xF4,0xB6,0xC8,0xFF,0x0F,0xAE,0x0F,
0x4F,0x4D,0x70,0x37,0x00,0x40,0xC0,0x40,0x00,0x1C,0xD3,0x0D,0x8D,0xF7,0xF4,0x79,
0x05,0xCF,0x7F,0xAD,0x0F,0xDF,0x72,0x70,0xC7,0x34,0x00,0x01,0x03,0x04,0xC0,0x71,
0xC0,0xD0,0x08,0x4F,0x6F,0x8B,0xFC,0xFF,0xD4,0xFA,0xF0,0x20,0x07,0x43,0x1C,0x03,
0x40,0xC0,0x00,0x01,0x30,0x71,0x0C,0xD0,0x35,0x0C,0xAF,0x57,0x3C,0xFF,0xD1,0xFA,
0x30,0xD7,0x04,0x0C,0x10,0x0C,0x40,0x00,0x03,0x01,0xC0,0x10,0xC0,0x40,0x23,0x33,
0xBC,0x5E,0xF5,0xF3,0x5F,0x27,0xC3,0x8C,0x1C,0x30,0x40,0xC0,0x00,0x04,0x0C,0x10,
0x00,0x43,0x00,0x0C,0x34,0x32,0xC3,0xEB,0x15,0x3F,0x7F,0xB4,0x3E,0xCC,0xC8,0x01,
0x03,0x04,0x03,0x40,0xC0,0x00,0x01,0x30,0x10,0xC0,0x40,0x23,0xC3,0xBC,0x5E,0xF1,
0xF7,0x5F,0x27,0x33,0x4C,0x1D,0xC0,0x00,0xC1,0x00,0x04,0x30,0x40,0x00,0x0C,0x04,
0x30,0x00,0xD4,0xC0,0x8C,0x50,0xFD,0xFD,0x47,0xEB,0x33,0x8C,0x00,0x30,0x00,0x01,
0x03,0x10,0xC0,0x00,0x01,0x30,0x10,0x00,0x03,0xB4,0x0C,0xC3,0xD8,0xD5,0xDF,0x7F,
0xB4,0x3E,0xCC,0x44,0x00,0x03,0x10,0xC0,0x00,0x04,0x30,0x40,0x00,0x0C,0x10,0x00,
0x03,0x04,0x0D,0xC3,0xD8,0x05,0x0F,0x7F,0x74,0x32,0xCC,0x44,0x00,0x0C,0x40,0xC0,
0x00,0x10,0xC0,0x00,0x01,0x30,0x40,0x00,0x0C,0x10,0xF8,0x30,0x63,0x57,0x3F,0xFC,
0xD4,0xC9,0x0C,0x13,0x01,0x30,0x00,0x01,0x0C,0x40,0x00,0x03,0x10,0xC0,0x00,0x01,
0xC0,0x00,0x11,0x03,0x73,0x72,0xC4,0xC3,0x5F,0x9C,0xC3,0x30,0x11,0x00,0x03,0x10,
0xC0,0x00,0x04,0xC0,0x00,0x01,0x30,0x00,0x01,0x30,0x00,0x11,0xC3,0x70,0x4E,0xF1,
0xFB,0x5F,0x9C,0xC3,0x30,0x11,0x00,0x03,0x40,0x00,0x03,0x10,0x00};

const unsigned char ph_ER_2bitDPCM[513]= {
0x08,0x00,0xC0,0x00,0x4D,0x00,0x13,0x03,0xC1,0x11,0xBF,0x3C,0xD1,0x10,0x30,0x31,
0x40,0x1C,0xC0,0x00,0x10,0x00,0x0C,0xD0,0x04,0x70,0x30,0x10,0x13,0xF1,0xF8,0x13,
0x4D,0x00,0x13,0x03,0xC4,0x01,0x0C,0x00,0x01,0xC0,0x00,0x4D,0x00,0x07,0x03,0xF5,
0xD2,0xBC,0x3F,0xD4,0x0B,0x30,0x31,0x40,0x1C,0xC0,0x00,0x10,0x00,0x0C,0x10,0x07,
0xC0,0xC1,0x40,0xBD,0x34,0xEF,0x0F,0xF5,0x02,0x4C,0x0C,0x10,0x07,0x30,0x00,0x10,
0x00,0x30,0x40,0x13,0xC0,0xC4,0x77,0x7E,0xC5,0x5F,0x3F,0xC8,0x14,0x33,0x0D,0x40,
0x13,0xC0,0x00,0x10,0x00,0xC0,0x00,0x34,0x01,0x4C,0x7C,0xDB,0x4B,0xFC,0xFE,0x87,
0x9F,0xF0,0xD0,0x00,0x71,0x00,0x0C,0x00,0x10,0x00,0x30,0x40,0x1C,0x00,0xC7,0x0C,
0xF6,0xE2,0xBF,0xFF,0xE8,0x17,0x3C,0x31,0x40,0x1C,0x00,0x03,0x00,0x01,0x00,0x0C,
0x40,0x13,0xC0,0xC4,0x4C,0x7E,0xD1,0x5F,0x3F,0xD4,0x1B,0x33,0x0D,0x40,0x13,0x00,
0x03,0x10,0x77,0x00,0x30,0x00,0x4D,0xD0,0x1C,0x33,0xC9,0x8B,0xFF,0xFE,0x97,0x5F,
0x0C,0xC7,0x07,0x74,0x00,0x0C,0x00,0x40,0x00,0x00,0x0C,0x40,0x00,0x00,0xC7,0x4C,
0xF5,0xD2,0xBC,0x3F,0xD4,0x27,0xC3,0x31,0x00,0x10,0x00,0x0C,0x40,0x4C,0x4C,0x00,
0xDC,0x00,0x01,0x34,0xC7,0x3D,0xF6,0x12,0xBF,0xFF,0x21,0x53,0xCC,0x34,0x07,0x10,
0xC0,0x31,0x00,0x71,0x0C,0x01,0x4C,0x03,0x04,0x00,0x1C,0xF7,0xD5,0x4B,0xFC,0xFE,
0x87,0x5F,0x7D,0xD3,0x00,0x40,0x00,0xC7,0x00,0x31,0xC1,0x04,0x30,0x0D,0x10,0x5C,
0x73,0xDC,0x63,0x2F,0xF1,0xFB,0x1F,0x35,0xC5,0x4C,0x73,0x0D,0x01,0x1C,0x03,0x04,
0x13,0x43,0x00,0xC7,0x00,0xC1,0x01,0xC0,0x3D,0xF6,0x45,0x7F,0xFD,0x50,0x53,0x7C,
0x37,0x00,0x10,0x00,0x03,0x00,0x04,0x30,0x10,0x00,0x30,0x00,0x01,0x00,0xDC,0x3D,
0xC5,0x45,0xFC,0xFE,0x47,0x9C,0x7C,0x37,0x40,0x43,0x00,0x30,0x00,0x04,0xC0,0x00,
0x04,0xC0,0x00,0x40,0x00,0x00,0x1C,0x5F,0x00,0xC5,0x1F,0x7F,0x04,0x14,0x1F,0x03,
0x00,0x04,0xC0,0x00,0x40,0x00,0x30,0x00,0x01,0x00,0x03,0x10,0x00,0xC0,0xD0,0x53,
0x40,0xF8,0xD3,0x0F,0x01,0xC5,0x07,0x03,0x00,0x04,0xC0,0x00,0x10,0x00,0x0C,0x00,
0x01,0x00,0x03,0x10,0x00,0xC0,0xD0,0x47,0x00,0xF5,0xD7,0x4F,0x00,0xD1,0x07,0x03,
0x00,0x04,0xC0,0x00,0x40,0x00,0x30,0x00,0x04,0x00,0x0C,0x40,0x00,0x00,0x43,0x4F,
0x01,0x14,0xBF,0xFF,0x05,0x50,0x7C,0x0C,0x00,0x10,0x00,0x0C,0x00,0x10,0x00,0x03,
0x40,0x00,0x00,0x03,0x40,0x00,0x00,0x43,0x5F,0x00,0xD4,0x5F,0x3F,0x01,0x44,0x1F,
0x0C,0x00,0x10,0x00,0x03,0x00,0x04,0x00,0x37,0x00,0x01,0x00,0x30,0x00,0x01,0x00,
0x0C,0x7D,0x04,0x50,0x3F,0xFE,0x04,0x40,0x3D,0x31,0x00,0x40,0x00,0x0C,0x00,0x40,
0x00,0xC0,0x00,0x10,0x00,0x00,0x03,0x10,0x00,0xC0,0xD0,0x47,0x00,0xF5,0xE3,0x4F,
0x00,0xD4,0x13,0x03,0x00,0x04,0x00,0x03,0x00,0x04,0x00,0x30,0x00,0x10,0x00,0x00,
0x0C,0x40,0x00,0x00,0x13,0x1F,0x01,0xD4,0x8F,0x3F,0x01,0x44,0x1F,0x0C,0x00,0x10,
0x70};

const unsigned char ph_EY_2bitDPCM[537]= {
0x08,0x00,0x00,0x30,0x00,0xC4,0x01,0x43,0x13,0x40,0x7C,0x0F,0x01,0x71,0x30,0xD0,
0x04,0x00,0x03,0x00,0x10,0x00,0xC0,0x00,0x40,0x1C,0x30,0x7D,0x01,0xC1,0xFB,0x07,
0x10,0x07,0x03,0x4D,0x00,0x30,0x00,0x00,0x01,0x00,0x0C,0x00,0xC1,0x01,0xD3,0xE7,
0x5D,0x7C,0x3F,0xC4,0x36,0x30,0xD0,0x04,0x00,0x03,0x00,0x10,0x00,0x00,0x03,0x40,
0x70,0xC0,0xF4,0x79,0x17,0xDF,0x0F,0x9D,0x1F,0x0C,0x00,0x01,0xC0,0x00,0x10,0x0C,
0x04,0x00,0x03,0x00,0x71,0xC0,0xD0,0x1B,0xD4,0xDF,0x7F,0x80,0x7D,0x0C,0x34,0x01,
0xC0,0x00,0x40,0xC0,0x10,0x00,0x30,0x00,0x04,0x07,0x43,0x9F,0x47,0xFD,0xFD,0x00,
0xC9,0xC0,0x1C,0x10,0x00,0x0C,0x00,0x04,0x0C,0x01,0x00,0x0C,0x00,0x71,0xCD,0xD0,
0x1B,0xE4,0xCF,0x7F,0xB0,0x7E,0x0C,0x34,0x01,0xC0,0x00,0x00,0x01,0x03,0x01,0x00,
0x03,0x4D,0x70,0xC0,0xF4,0x09,0xD4,0xDF,0x0F,0x90,0x1F,0x0C,0x00,0x71,0xC0,0x00,
0x40,0x00,0x03,0x01,0x00,0x0C,0x34,0x35,0xCD,0xD7,0xEB,0x2D,0x7F,0x3F,0xB7,0x7E,
0x3D,0xC7,0xC5,0x01,0x03,0x00,0x04,0x30,0x10,0x00,0x00,0x03,0x4D,0x0D,0xF0,0xF5,
0x06,0xF8,0xF7,0x1F,0x60,0xD3,0x03,0x40,0x1C,0xC0,0x00,0x00,0x04,0x37,0x10,0x00,
0x00,0x03,0x4D,0x0D,0xF0,0xF5,0x46,0xCB,0xF3,0xDF,0xAD,0xD3,0x03,0x5C,0x1C,0x00,
0x0C,0x00,0x04,0x30,0x10,0x00,0x30,0x00,0x34,0x35,0xC0,0xD7,0x08,0x04,0xDF,0x0F,
0x90,0x5F,0x0F,0x00,0x4D,0x00,0x30,0x00,0x10,0x30,0x10,0x00,0x30,0x00,0xC4,0x35,
0xC0,0xD7,0x1B,0x2D,0x3F,0x7F,0xB7,0x4E,0x0F,0x70,0x71,0x00,0x30,0x00,0x00,0xC1,
0x00,0x01,0x00,0x03,0x40,0x53,0x03,0x7C,0xBD,0x01,0xF1,0xFD,0x00,0xC8,0xF5,0x00,
0xD7,0x04,0x00,0x03,0x00,0x04,0x0C,0x10,0x00,0xC0,0x00,0x40,0x40,0x03,0x7C,0x8D,
0x74,0xF0,0xFD,0x1C,0xF9,0xF2,0xC0,0x01,0x04,0x00,0x03,0x00,0x10,0xDC,0x10,0x00,
0x00,0x0C,0x00,0x01,0x00,0xF0,0xC8,0x05,0xC4,0xC3,0x03,0x20,0xD7,0x37,0x1C,0x10,
0x00,0x30,0x00,0x00,0x04,0x0C,0x01,0x00,0x0C,0x00,0x40,0x40,0xC3,0x7D,0x8D,0x00,
0xF1,0xFD,0x00,0x38,0xF2,0x0D,0x00,0x74,0x00,0xC0,0x00,0x00,0xC4,0x04,0x00,0x00,
0x03,0x40,0x1C,0x00,0x30,0x40,0x2C,0x00,0xBC,0x3F,0x40,0x4D,0x00,0x03,0x00,0x40,
0x00,0x00,0x03,0x00,0x40,0x00,0x00,0x30,0x00,0x00,0x01,0x00,0x30,0x70,0x5D,0x70,
0x30,0x3C,0x00,0x41,0x00,0x0C,0x00,0x40,0x07,0x00,0x0C,0x00,0x40,0x13,0x00,0x70,
0x03,0x40,0x00,0x00,0xC0,0x00,0x10,0x47,0x1C,0xEF,0xDF,0x44,0x13,0xC0,0x0D,0x00,
0x00,0x01,0x00,0x30,0x00,0x34,0x1D,0x00,0x30,0x00,0x40,0x00,0x00,0x30,0x40,0x13,
0x40,0x1C,0xEF,0xDF,0x10,0x04,0xC0,0xDD,0x00,0x00,0x04,0x00,0x30,0x00,0xD0,0x71,
0x00,0x30,0x00,0x00,0x01,0x00,0xC0,0x00,0x40,0x00,0x0D,0x7D,0x1F,0x13,0x40,0x07,
0xC7,0x00,0x00,0x10,0x00,0xC0,0x0D,0x00,0x34,0x01,0x00,0x0C,0x00,0x40,0x00,0x00,
0x30,0x00,0x10,0x40,0x4C,0xEF,0xC3,0x04,0x10,0xC0,0x31,0x00,0x00,0x04,0x00,0x00,
0x03,0x00,0x4D,0x1C,0x00,0x70,0x03,0x00,0x04,0x00,0x00,0x0C,0x00,0x04,0x10,0xD3,
0x37,0x30,0x01,0x04,0x70,0x0C,0x00,0x00,0x10};

const unsigned char ph_F_2bitDPCM[205]= {
0x08,0xC0,0x10,0x0C,0xC1,0xC4,0x4D,0xC0,0xC4,0xC4,0x40,0x1C,0x4C,0xD3,0x04,0xC7,
0x4D,0x30,0xDD,0x04,0x4C,0x1C,0xC7,0xC4,0x40,0x0C,0x4D,0x1C,0x43,0xC0,0x31,0xC4,
0xDD,0x4D,0x30,0x4D,0xC7,0x04,0x03,0xC1,0x34,0x4D,0x30,0xC4,0xC4,0x4D,0xD3,0x4D,
0x30,0x71,0x00,0x13,0xC7,0x4D,0x30,0x34,0xC1,0x40,0x07,0x03,0x1D,0x0C,0x71,0x07,
0x03,0x71,0x07,0x4C,0x00,0x13,0x77,0x30,0xDD,0x04,0x0C,0x74,0x30,0x10,0xDC,0x10,
0xC7,0x4D,0x13,0xD3,0x04,0x4C,0x30,0xC1,0x10,0x30,0x10,0x0C,0x71,0x07,0x03,0x1D,
0xD3,0x01,0x13,0x43,0x4C,0x0C,0xC1,0xC4,0x10,0x4C,0x4C,0x07,0x0C,0xC4,0x31,0x40,
0xDC,0xD0,0x74,0x43,0x00,0x4C,0x30,0xDD,0xD0,0xC1,0x4D,0x1C,0x13,0x77,0x43,0x43,
0x4C,0xC0,0x71,0xD3,0xDD,0x10,0xC7,0x04,0x70,0x0C,0xC1,0xC1,0x0D,0x71,0x37,0x71,
0x03,0x04,0x1C,0x07,0x77,0xC0,0x1D,0x4C,0xD3,0xC4,0x04,0xC7,0x00,0x31,0x10,0x37,
0x31,0x04,0xC7,0xDD,0x40,0xDC,0x04,0x70,0xDC,0x71,0xD3,0x71,0x13,0x13,0xC7,0x4D,
0x37,0x40,0x13,0xD3,0x31,0x40,0x1C,0x13,0x43,0x77,0xD3,0x4D,0x70,0x4C,0x30,0xC1,
0xC4,0x04,0x0C,0xDD,0x4D,0x13,0x30,0x34,0x31,0x01,0x13,0x4C,0x13};

const unsigned char ph_G_2bitDPCM[161]= {
0x08,0x1C,0xC7,0x34,0xC1,0x71,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x00,
0x00,0x1D,0x70,0x03,0x4D,0x13,0xC7,0x40,0x07,0x00,0x00,0x00,0x00,0x00,0xC0,0x34,
0x31,0x00,0x00,0x00,0x0D,0x00,0x00,0x04,0x00,0x03,0x00,0x10,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x00,0x00,0x00,
0x00,0x00,0x1C,0x00,0x10,0xC0,0xDC,0x03,0x00,0x75,0x00,0x00,0x03,0x00,0xC4,0x10,
0x03,0x31,0x01,0x00,0x4C,0x0C,0x00,0x14,0x10,0xFC,0xFD,0x04,0x20,0x00,0x30,0x00,
0x40,0x0C,0x31,0xC4,0x04,0x13,0x4C,0x00,0x00,0x43,0x1F,0x35,0xD5,0x7F,0xFF,0xC9,
0x45,0x4F,0x0C,0xD0,0x10,0x30,0xC4,0x10,0x30,0xC1,0x10,0x43,0x00,0x00,0x4F,0x71,
0xCA,0x3F,0xFF,0xD9,0x44,0x3F,0x01,0x04,0x0C,0x31,0x04,0x43,0x0C,0xC1,0x04,0x03,
0x31,0x05,0x4F,0xC3,0xEA,0x7F,0xFF,0x6B,0x73,0xCC,0x14,0x4C,0xC0,0x40,0x30,0x00,
0x01};

const unsigned char ph_HH_2bitDPCM[121]= {
0x07,0x40,0x00,0xC0,0x10,0x43,0x4C,0x30,0xC1,0xD0,0x10,0x70,0xC0,0x31,0x74,0x13,
0x70,0x0C,0x40,0xC0,0xC4,0xD0,0x10,0x4C,0x4C,0x30,0x31,0xD0,0xC4,0x40,0x4C,0x70,
0xC0,0xC1,0x10,0x43,0x4C,0x0C,0xC1,0x04,0x13,0x43,0x4C,0x0C,0xC4,0x04,0x13,0x4C,
0x30,0x34,0x10,0x07,0xC0,0x0D,0x4D,0x00,0x1C,0x30,0xD0,0x04,0xC7,0x10,0x43,0x30,
0xC4,0x10,0x4C,0x4C,0x30,0xC1,0x04,0x13,0x43,0x0C,0x31,0xC4,0x01,0x43,0x03,0xC4,
0x01,0x13,0x43,0x4C,0x00,0x00,0xD3,0x40,0x70,0x30,0xD0,0x10,0x00,0x0C,0x00,0xC1,
0x01,0xC0,0x40,0x43,0x70,0x00,0x0C,0x31,0x04,0x13,0x0C,0x31,0xC4,0x04,0x13,0x0C,
0x0D,0xC1,0xC4,0x10,0x43,0x0C,0x31,0xC1,0x04};

const unsigned char ph_IH_2bitDPCM[209]= {
0x07,0x00,0x00,0x04,0x00,0x00,0x30,0x00,0x40,0x40,0x30,0x7D,0x1F,0x13,0x10,0x00,
0x00,0x03,0x00,0x00,0x01,0x00,0x0C,0x00,0x10,0x00,0x00,0x30,0x00,0x40,0x00,0x31,
0x7D,0x1F,0x13,0x40,0x00,0x00,0x03,0x00,0x00,0x01,0x00,0x0C,0x00,0x04,0x00,0x00,
0x0C,0x00,0x10,0x04,0x00,0xCC,0x03,0x47,0x10,0x00,0xC0,0x00,0x00,0x00,0x01,0x00,
0x03,0x00,0x01,0x00,0x00,0x0C,0x00,0x10,0x44,0x03,0xEF,0xCF,0x41,0xC4,0x35,0xC0,
0x00,0x00,0x40,0x00,0x00,0x03,0x00,0x01,0x00,0x00,0x03,0x4C,0xE0,0x11,0x43,0xDF,
0xCF,0x44,0xDB,0xC4,0xC0,0x00,0x00,0x40,0x00,0x00,0x03,0x00,0x01,0x00,0x00,0x0C,
0x4C,0xE0,0x41,0x4C,0xDF,0xCF,0x44,0xE7,0xC4,0xC0,0x00,0x00,0x40,0x00,0x00,0x03,
0x00,0x01,0x40,0x03,0x73,0x43,0xE0,0x51,0x43,0xCF,0xFF,0x45,0xDB,0xC1,0xC0,0xC0,
0x01,0x40,0x00,0xC0,0x00,0x00,0x01,0x00,0x00,0x03,0x53,0xE3,0x11,0x43,0xCF,0xC3,
0x44,0xCB,0x32,0xC0,0x00,0x00,0x40,0x00,0xC0,0x00,0x00,0x01,0x00,0x00,0x03,0x83,
0xE3,0x51,0x4F,0xDF,0x3F,0x44,0xCB,0xC2,0xC0,0x00,0x00,0x40,0x00,0x00,0x03,0x00,
0x01,0x00,0x00,0x0C,0x4C,0x5D,0x47,0x0C,0xCC,0x03,0x07,0x11,0xC4,0x00,0x03,0x00,
0x00};

const unsigned char ph_IY_2bitDPCM[453]= {
0x07,0x04,0x00,0x00,0x00,0x03,0x00,0x00,0x71,0x00,0x31,0x7D,0x03,0x07,0xD0,0x04,
0x00,0x00,0x30,0x00,0x00,0x00,0x1D,0x00,0x00,0x00,0x03,0x00,0x00,0x74,0x00,0x31,
0xBD,0x0F,0x13,0x1C,0x04,0x00,0x00,0x30,0x00,0x00,0x00,0x01,0x00,0x00,0xC0,0x00,
0x00,0x00,0x4E,0x07,0x70,0xEF,0x33,0x00,0xD4,0x01,0x00,0x00,0x0C,0x00,0x00,0x40,
0x07,0x00,0x00,0x30,0x00,0x00,0x40,0x2C,0x00,0x1C,0xC3,0x30,0x00,0x38,0x01,0x00,
0x00,0x03,0x00,0x00,0x40,0x00,0x00,0x00,0x30,0x00,0x70,0x80,0x13,0xD0,0xEC,0xFB,
0xCF,0xC1,0x76,0x40,0x0C,0x00,0x03,0x00,0x00,0x40,0x00,0x00,0x00,0x30,0x00,0x1C,
0x80,0x13,0xD0,0xEC,0xFB,0xCF,0xC1,0xB2,0x40,0x0C,0x00,0x03,0x00,0x00,0x40,0x00,
0x00,0x00,0x0C,0x4C,0x13,0x6C,0x3B,0xC4,0xE0,0xF3,0x33,0x71,0x8E,0x43,0x13,0xC3,
0x34,0x00,0x00,0x10,0x00,0x00,0x70,0x0C,0x00,0x47,0xE3,0x01,0x34,0xFB,0xFE,0x73,
0x80,0x2F,0x00,0x00,0xC0,0x0D,0x00,0x00,0x10,0x00,0x00,0x70,0x03,0x13,0x47,0xD7,
0x01,0x31,0xFB,0xFD,0x4C,0x80,0xE3,0xD0,0x34,0xC0,0x0D,0x00,0x00,0x10,0x00,0x00,
0x30,0x00,0x00,0x40,0xD7,0x01,0x34,0xFB,0xFD,0x1C,0x80,0xE3,0x00,0x00,0x00,0x0C,
0x00,0x00,0x10,0x00,0x00,0x30,0x00,0x1C,0x40,0xD7,0x01,0x34,0xFB,0xFD,0x1C,0x40,
0xD7,0x01,0x34,0x00,0x0C,0x00,0x00,0x04,0x00,0x00,0x0C,0x00,0x00,0xD0,0x75,0x00,
0xC0,0x3E,0x33,0x00,0xD0,0x75,0x00,0x00,0x00,0x03,0x00,0x40,0x00,0x00,0xC0,0x00,
0x70,0x00,0x5D,0x07,0x00,0xE3,0x33,0x73,0x00,0x5D,0x07,0x00,0x00,0x30,0x00,0x00,
0x04,0x00,0x00,0x0C,0x00,0x00,0xC4,0x4E,0x00,0x70,0xDC,0x33,0x34,0xC4,0x4E,0x00,
0x00,0xC0,0x00,0x00,0x40,0x00,0x00,0xC0,0x00,0x00,0x40,0xEC,0x04,0x00,0xC7,0x3D,
0x43,0x43,0x2C,0x07,0x00,0x00,0x30,0x00,0x00,0x04,0x00,0x00,0x0C,0x00,0x00,0xD0,
0x35,0x31,0x31,0x4D,0xCF,0xC4,0xC1,0x75,0x00,0x00,0x00,0x03,0x00,0x00,0x01,0x00,
0xDC,0x00,0x00,0x00,0x5D,0x43,0x1C,0xE3,0xF7,0x4C,0x1C,0x5C,0x07,0x00,0x00,0x70,
0x03,0x00,0x04,0x00,0x70,0x0C,0x00,0x00,0xC4,0x01,0x40,0xB3,0xEF,0xC3,0x71,0x00,
0x1D,0x07,0x00,0xC0,0x31,0x00,0x10,0x00,0xC0,0x0D,0x00,0x40,0xD3,0x01,0x34,0x0D,
0x0D,0x37,0xC7,0x01,0x71,0x1C,0x00,0x00,0x30,0x00,0x40,0x00,0xC0,0x00,0x00,0x00,
0x10,0x07,0x00,0xC0,0xBE,0x0F,0x00,0x00,0x34,0x1D,0x00,0x00,0xC0,0x31,0x4D,0x1C,
0xDC,0x00,0x00,0x00,0x4D,0x07,0x00,0x00,0x34,0x0C,0x00,0x00,0xD0,0x71,0x00,0x00,
0x00,0xC0,0x31,0x4D,0x4C,0x03,0x00,0x00,0x71,0x1C,0x00,0x00,0xC7,0x0D,0x00,0x00,
0xD0,0x74,0x00,0x00,0x00};

const unsigned char ph_JH_2bitDPCM[117]= {
0x07,0xD0,0x01,0x00,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x00,
0xD0,0x00,0x74,0xD3,0xD0,0x71,0x77,0x77,0xC7,0xC1,0x1D,0x07,0x07,0x00,0x00,0xC0,
0x0D,0x00,0x00,0x00,0xDD,0x71,0xD3,0x0D,0x74,0xD3,0xDD,0x71,0xC7,0x1D,0xC7,0x1D,
0x07,0x00,0x00,0xC0,0x4D,0x03,0x00,0x40,0xD3,0x34,0x4D,0x13,0xC7,0xDD,0x74,0x77,
0xC0,0xC1,0x71,0x1C,0x00,0x00,0x00,0x70,0x03,0x00,0x00,0xD0,0x74,0xDC,0x00,0x00,
0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x03,0x40,0x00,0x01,
0x00,0x03,0x00,0x40,0x30,0xC1,0x10,0x13,0x00,0x30,0x00,0x00,0x14,0x40,0xF3,0xFD,
0x04,0x14,0x00,0x30,0x31};

const unsigned char ph_K_2bitDPCM[95]= {
0x08,0xDC,0xDD,0x1D,0x00,0x13,0x00,0x00,0x00,0x07,0x30,0x4D,0x00,0x00,0x00,0x1C,
0x1C,0x1C,0x00,0x00,0x13,0x00,0x00,0x00,0x1C,0x1C,0x00,0x00,0xC0,0x31,0x01,0x00,
0x00,0x1C,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0C,0x10,0x00,0x03,0x10,0x00,0x00,0x30,0x40,0x04,0x30,0xCC,0x1C,0x11,0xCD,0x00,
0x00,0x40,0x00,0x30,0x00,0x01,0x0C,0x04,0x0C,0x10,0x00,0x0C,0x40,0x00,0x00,0xC0,
0x4C,0x54,0x30,0xDF,0x33,0x54,0xC4,0x30,0x00,0x00,0x01,0xC0,0x00,0x00,0x01};

const unsigned char ph_L_2bitDPCM[225]= {
0x07,0x00,0x01,0x00,0x0C,0x00,0x01,0x00,0x30,0x4C,0x24,0xF1,0xDF,0xF3,0x61,0xC4,
0x30,0x00,0x00,0x01,0x00,0x03,0x00,0x01,0xC0,0x00,0x10,0x00,0x30,0x00,0x10,0x00,
0x00,0xC3,0x44,0x02,0xC3,0x3C,0x03,0x46,0x0C,0x03,0x00,0x40,0x00,0x30,0x00,0x10,
0x00,0x0C,0x00,0x01,0x00,0x0C,0x00,0x01,0x00,0xC0,0x70,0x51,0xC7,0x7C,0xCF,0x50,
0xD4,0xC0,0x00,0x00,0x10,0x00,0x0C,0x00,0x04,0x00,0x0C,0x00,0x01,0x00,0x0C,0x00,
0x01,0x00,0x30,0x00,0x44,0xD0,0x37,0xDF,0x07,0x11,0x00,0x03,0x00,0x40,0x00,0x30,
0x00,0x40,0x00,0xC0,0x00,0x40,0x00,0x00,0x03,0x40,0x00,0x00,0x30,0x00,0x41,0xC0,
0x7D,0xF3,0x41,0x04,0x00,0x03,0x00,0x40,0x00,0x30,0x00,0x10,0x00,0xC0,0x00,0x00,
0x01,0x00,0x03,0x10,0x00,0x00,0x30,0x00,0x44,0xC0,0x70,0xC3,0x40,0x10,0x00,0x03,
0x00,0x00,0x01,0x30,0x00,0x10,0x00,0xC0,0x00,0x00,0x04,0x00,0x03,0x10,0x00,0x00,
0x30,0x00,0x41,0xDC,0x70,0xC3,0x4D,0x10,0x00,0x03,0x00,0x00,0x01,0x30,0x00,0x04,
0x30,0x00,0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x31,0x00,0x00,0x00,0x00,
0x00,0x00,0x04,0x00,0x00,0x30,0x00,0x00,0x40,0xC0,0x04,0x00,0x00,0x00,0x00,0x30,
0x0D,0x00,0x00,0x00,0x00,0x40,0x0C,0x01,0x00,0x00,0x0C,0x00,0x00,0x10,0x0C,0x01,
0x00};

const unsigned char ph_M_2bitDPCM[191]= {
0x08,0x00,0x00,0x30,0x31,0x00,0x00,0x00,0x00,0x40,0x30,0x04,0x00,0x00,0x0C,0x00,
0x00,0x04,0x4C,0x00,0x00,0x00,0x00,0x00,0x13,0x03,0x00,0x00,0x00,0x00,0xC4,0x40,
0x00,0x00,0xC0,0x00,0x00,0x00,0xC1,0x04,0x00,0x00,0x00,0x00,0x30,0x31,0x00,0x00,
0x00,0x00,0x40,0x30,0x04,0x00,0x00,0x0C,0x00,0x00,0x04,0x4C,0x00,0x00,0x00,0x00,
0x00,0x13,0x03,0x00,0x00,0x00,0x00,0xC4,0x10,0x00,0x00,0xC0,0x00,0x00,0x40,0x30,
0x04,0x00,0x00,0x00,0x00,0x70,0x0C,0x00,0x00,0x00,0x00,0x10,0x0C,0x01,0x00,0x00,
0x03,0x00,0x00,0xC1,0x10,0x00,0x00,0x00,0x00,0xC0,0x31,0x00,0x00,0x00,0x00,0x40,
0x30,0x04,0x00,0x00,0x0C,0x00,0x00,0xC1,0x10,0x00,0x00,0x00,0x00,0xC0,0xC4,0x00,
0x00,0x00,0x00,0x00,0x31,0x04,0x00,0x00,0x0C,0x00,0x00,0x00,0x00,0x01,0x07,0x03,
0x04,0x00,0x07,0x4C,0x0C,0xC1,0xC1,0x10,0x40,0x73,0xCC,0x01,0x04,0x13,0x43,0x30,
0x31,0xC4,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x43,0x4C,0x30,0xC1,0xD0,0x10,0x00,
0xCD,0x31,0x07,0x40,0x4C,0x30,0xD0,0x10,0x13,0x30,0x00,0x00,0x40,0x00,0x00};

const unsigned char ph_N_2bitDPCM[245]= {
0x07,0x00,0x00,0xD0,0x10,0x00,0x40,0x00,0xC3,0x0D,0x03,0x04,0x00,0x10,0x00,0x00,
0x00,0x30,0x00,0x00,0x40,0x00,0x00,0x00,0x03,0x00,0x00,0x34,0x01,0x00,0x10,0xC0,
0x30,0x30,0x00,0x01,0x00,0xC4,0x01,0x00,0x00,0x0C,0x00,0x00,0x40,0x00,0x00,0x00,
0x03,0x00,0x00,0x34,0x04,0x00,0x10,0xC0,0x30,0x30,0x00,0x01,0x00,0xC4,0x01,0x00,
0x00,0x30,0x00,0x00,0x40,0x00,0x00,0x00,0x0C,0x00,0x00,0xD0,0x04,0x00,0x40,0x00,
0xC3,0xC0,0x00,0x04,0x00,0x10,0x07,0x00,0x00,0xC0,0x00,0x00,0x00,0x01,0x00,0x00,
0x30,0x00,0x00,0x00,0x4D,0x00,0x00,0x04,0x30,0x0C,0x0C,0x40,0x00,0x00,0x31,0x01,
0x00,0x00,0x30,0x00,0x00,0x00,0x01,0x00,0x00,0x0C,0x00,0x00,0x00,0x31,0x01,0x00,
0x10,0x0C,0xC0,0x00,0x77,0x00,0x00,0x34,0x04,0x00,0x00,0x00,0x03,0x00,0x00,0x10,
0x00,0x00,0x00,0x0C,0x00,0x00,0x00,0xC1,0x01,0x00,0x00,0x00,0x70,0x03,0x00,0x00,
0x00,0x00,0xC4,0x01,0x00,0x00,0x0C,0x00,0x00,0x00,0x01,0x00,0x00,0xC0,0x00,0x00,
0x00,0x4D,0x70,0x00,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x00,0x0D,0x01,0x00,0x00,
0x00,0x03,0x00,0x00,0x10,0x43,0x30,0x10,0x13,0xC0,0x00,0x40,0xC1,0x1C,0x33,0x11,
0x00,0x0C,0x00,0x10,0x70,0xC0,0x00,0x40,0x00,0x37,0x10,0xC0,0xC4,0x40,0x0C,0x01,
0xC7,0x0D,0x04,0x10,0x33,0xCD,0x04,0x10,0x00,0xC0,0x00,0x00,0x71,0x00,0x03,0x40,
0xC0,0x10,0x00,0x0C,0x40};

const unsigned char ph_NG_2bitDPCM[293]= {
0x08,0x00,0x43,0xC0,0x01,0x00,0x10,0x03,0x03,0x4C,0x00,0x00,0x00,0x01,0x00,0x0C,
0x00,0x00,0x00,0x01,0x0C,0x04,0x00,0x00,0x00,0x0C,0x00,0x10,0x00,0x00,0x04,0x30,
0x30,0x0C,0x10,0x00,0x00,0x10,0x00,0x30,0x00,0x00,0x00,0x40,0xC0,0x00,0x01,0x00,
0x00,0x00,0x0C,0x00,0x04,0x00,0x00,0x04,0x30,0x30,0x0C,0x10,0x00,0x00,0x04,0x00,
0x30,0x00,0x00,0x00,0x40,0x00,0x03,0x01,0x00,0x00,0x00,0x0C,0x00,0x10,0x00,0x00,
0x04,0x30,0x30,0x0C,0x10,0x00,0x00,0x04,0x00,0x30,0x00,0x00,0x00,0x40,0xC0,0x00,
0x01,0x00,0x00,0x00,0x0C,0x00,0x04,0x00,0x00,0x04,0x30,0x0C,0x0C,0x10,0x00,0x00,
0x04,0x00,0x30,0x00,0x00,0x00,0x40,0xC0,0x00,0x01,0x00,0x00,0x00,0x0C,0x00,0x04,
0x00,0x00,0x04,0x30,0x30,0x0C,0x10,0x00,0x00,0x10,0x00,0x30,0x00,0x00,0x00,0x40,
0x00,0x03,0x10,0x00,0x00,0x00,0xC0,0x00,0x40,0x00,0x00,0x00,0xC1,0xC0,0x00,0x13,
0x00,0x00,0x00,0x01,0x00,0x03,0x00,0x00,0x00,0x10,0xC0,0x00,0x01,0x00,0x00,0x00,
0x0C,0x00,0x04,0x00,0x00,0x00,0x0D,0x30,0xC0,0x01,0x00,0x00,0x40,0x00,0xC0,0x00,
0x00,0x00,0x00,0x01,0x0C,0x40,0x00,0x00,0x00,0x00,0x0C,0x00,0x04,0x00,0x00,0x00,
0x00,0x0C,0x00,0x00,0x00,0x00,0x10,0x00,0x30,0x00,0x00,0x00,0x00,0x01,0x0C,0x40,
0x00,0x00,0x00,0x00,0x0C,0x00,0x10,0x00,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x00,
0x40,0x00,0xC0,0x00,0x00,0x10,0x30,0x00,0x10,0x00,0x70,0x0C,0x20,0x30,0x37,0x03,
0x05,0x4C,0x03,0x00,0x01,0x00,0x03,0x01,0x03,0x01,0x03,0x00,0x01,0x00,0xC7,0x40,
0x01,0x73,0x33,0x20,0xC0,0x34,0x00,0x10,0x00,0x30,0x10,0x30,0x10,0x30,0x00,0x10,
0x00,0x70,0x0C,0x24,0xCC};

const unsigned char ph_OW_2bitDPCM[565]= {
0x07,0xCC,0x24,0xC0,0x34,0x00,0x10,0x00,0x30,0x10,0x30,0x10,0x30,0x00,0x40,0x00,
0x70,0xF0,0x91,0xF0,0xD3,0x33,0x49,0x33,0x0D,0x00,0x01,0x00,0x0C,0x04,0x0C,0x10,
0xC0,0x00,0x40,0x00,0x00,0xF0,0x91,0x3D,0xDF,0xCF,0x4A,0x3C,0x0D,0x1C,0x04,0x00,
0x0C,0x04,0x30,0x40,0x00,0x03,0x0D,0x04,0x00,0xC7,0x13,0x3A,0x7F,0xFC,0x67,0xF4,
0x00,0x70,0x10,0x4C,0x30,0x40,0x00,0x03,0x10,0x30,0xD0,0x40,0xC4,0x00,0x3C,0xA1,
0xF0,0xDF,0x3F,0x4A,0x3C,0x00,0x13,0x01,0x13,0x0C,0x10,0xC0,0x00,0x01,0x0C,0x31,
0x10,0x00,0x00,0x7C,0x64,0xCF,0xF7,0x73,0x16,0x0F,0x00,0x00,0xC1,0x10,0x03,0x04,
0xC0,0x00,0x04,0x4C,0xC0,0x10,0x00,0x00,0x3C,0xA1,0xFC,0xC7,0x3F,0x4A,0x3C,0x00,
0x00,0x04,0x43,0x0C,0x10,0x00,0x03,0x10,0x00,0x13,0x0C,0x04,0x00,0xC0,0x13,0xD9,
0xF3,0xFD,0x9C,0xC5,0x03,0x00,0x40,0xC0,0x10,0x03,0x04,0x00,0x03,0x10,0xC0,0x04,
0x03,0x01,0x00,0xC0,0x13,0xCA,0x7F,0xFC,0xA3,0xC4,0x03,0x00,0x40,0xC0,0x10,0x03,
0x04,0x00,0x03,0x10,0xC0,0x04,0x03,0x01,0x00,0xC0,0x13,0x3A,0x3F,0xFD,0xAC,0xC4,
0x03,0x00,0x40,0x00,0x13,0x03,0x10,0x00,0x03,0x04,0xC0,0xC4,0x00,0x01,0x00,0xC0,
0x2F,0xCA,0xF3,0xFD,0x93,0xD5,0x0F,0x00,0x40,0x00,0x43,0x03,0x10,0x00,0x03,0x10,
0x00,0x07,0x03,0x04,0x00,0x00,0x4F,0xE8,0xFC,0xF4,0x7C,0x16,0x3C,0x00,0x00,0x04,
0x0C,0xC1,0x00,0x01,0x30,0x00,0x01,0x0C,0xC1,0x00,0x01,0x40,0xC3,0x6F,0xC9,0x3F,
0x3D,0x8F,0xD6,0xCF,0x01,0x00,0x01,0x0C,0x34,0x00,0x01,0x30,0x00,0x01,0x30,0x04,
0x03,0x04,0x00,0x00,0x4F,0xE5,0xFC,0x34,0x7F,0x52,0x3C,0x00,0x00,0x04,0x30,0x10,
0x03,0x10,0x00,0x03,0x10,0xC0,0x04,0x0C,0x10,0x00,0x00,0x33,0x54,0xCE,0x4F,0xF3,
0x63,0x05,0x0F,0x00,0x00,0x04,0xDC,0x31,0x00,0x01,0x30,0x00,0x01,0x0C,0x00,0x40,
0x00,0x00,0x30,0x4C,0x15,0x33,0xC7,0x3C,0x85,0x30,0x03,0x00,0x00,0x01,0x00,0x0C,
0x40,0x00,0x0C,0x10,0x00,0x03,0x00,0x04,0x00,0x00,0x0C,0x53,0x05,0xCF,0x34,0x0F,
0x55,0x30,0x03,0x34,0x00,0x10,0x00,0x0C,0x00,0x01,0x0C,0x40,0x00,0x0C,0x00,0x01,
0x00,0x1C,0xC0,0x00,0x51,0x3C,0xDC,0x30,0x47,0x01,0x30,0x10,0x03,0x00,0x01,0x00,
0x03,0x10,0xC0,0x00,0x04,0xC0,0x00,0x40,0x00,0xC0,0x04,0x0C,0x40,0x11,0x0F,0x37,
0xCC,0x51,0x00,0x0C,0xC4,0x00,0x00,0x01,0xC0,0x00,0x04,0xC0,0x00,0x04,0xC0,0x00,
0x10,0x00,0x30,0x04,0x0C,0x40,0x01,0x0C,0x37,0x0C,0x50,0x00,0x0C,0x04,0x03,0x00,
0x04,0xC0,0x00,0x04,0xC0,0x00,0x04,0x00,0x03,0x10,0x00,0xC0,0x40,0x0C,0x00,0x05,
0x30,0x4C,0xC3,0x00,0x05,0x00,0x13,0x30,0x00,0x40,0x00,0x30,0x00,0x04,0xC0,0x00,
0x04,0xC0,0x00,0x10,0x00,0x00,0x37,0x31,0x00,0x50,0xC0,0x30,0x0D,0x03,0x14,0x00,
0x30,0x0D,0x00,0x00,0x10,0x00,0x0C,0x00,0x01,0x30,0x00,0x01,0xC0,0x00,0x10,0x00,
0x00,0x00,0xC7,0x00,0x10,0x01,0xC3,0x34,0x0C,0x50,0x00,0xC0,0x71,0x0C,0x00,0x40,
0x00,0x30,0x00,0x04,0x00,0x30,0x40,0x00,0x03,0x04,0x4C,0x00,0x0C,0x44,0x0C,0xF7,
0x4D,0x14,0x33,0x40,0x0C,0x04,0x30,0x40,0x00,0x03,0x04,0x30,0x10,0xC0,0x04,0x30,
0x53,0xC4,0x7D,0x0F,0x44,0xF1,0x1C,0xC4,0x40,0x00,0x03,0x04,0x30,0x10,0xC0,0x00,
0x01,0x4C,0xC4,0x0F,0x55};

const unsigned char ph_OY_2bitDPCM[603]= {
0x06,0xF0,0x56,0xFD,0x13,0xC1,0x40,0x00,0x03,0x04,0x30,0x40,0x00,0x03,0x04,0x4C,
0xC4,0xCF,0x59,0x3D,0xF3,0xBC,0x25,0xFF,0x44,0x0C,0x10,0xCD,0x00,0x01,0x0C,0x10,
0xCD,0x1C,0x01,0x43,0xC5,0xFF,0xA9,0xFC,0xF7,0x7F,0x69,0xFF,0x53,0xC0,0x10,0xCD,
0x4C,0x01,0x0C,0x10,0x34,0x73,0x04,0x03,0x12,0xFF,0xA7,0xF2,0xDF,0xFF,0xA5,0xFD,
0x0F,0x02,0x43,0x34,0x73,0x10,0xC0,0x1C,0x11,0xCF,0x14,0x3D,0x67,0xF1,0x7F,0x2A,
0xFF,0xFC,0x5F,0xEA,0xFF,0x17,0x30,0x44,0x33,0x13,0x01,0x0C,0x10,0x00,0x03,0x04,
0x03,0x55,0xFF,0xAF,0xFA,0x3F,0xFF,0xA4,0xF2,0x3F,0x05,0x0C,0x01,0x0C,0x40,0x00,
0x03,0x04,0xC0,0x00,0x01,0x03,0x46,0xFF,0xA3,0xF6,0xFF,0xF3,0xA4,0xF2,0x3F,0x02,
0x0C,0x01,0x0C,0x40,0x00,0x0C,0x10,0x00,0x03,0x04,0x0C,0x14,0xFD,0x8F,0xDA,0xFF,
0xFE,0x5F,0xDA,0xFF,0x14,0x30,0x10,0xC0,0x00,0x04,0xC0,0x00,0x01,0xC0,0x00,0x01,
0x03,0x06,0xFF,0xA7,0xF6,0x3F,0xFF,0xA4,0xF2,0x3F,0x05,0x0C,0x04,0x30,0x00,0x01,
0x30,0x40,0x00,0x00,0x03,0xC4,0x4D,0xD1,0xFF,0x69,0xFD,0xC3,0x7F,0x29,0xFF,0x04,
0x00,0x01,0x0C,0x00,0x40,0x00,0x0C,0x10,0x00,0x07,0x0C,0x10,0x00,0x34,0x7F,0x2A,
0xFF,0xFD,0x9F,0xC6,0x7F,0xC0,0x11,0x30,0x04,0x03,0x10,0x00,0x03,0x04,0x00,0x0C,
0x0D,0x10,0xF1,0x71,0x4F,0x19,0xFF,0xFE,0xAF,0xF1,0x71,0x4F,0x04,0x00,0x0C,0x00,
0x10,0x00,0x03,0x10,0x00,0x00,0x03,0x0D,0x11,0xCF,0x35,0xA0,0xFD,0xF7,0xBF,0x02,
0xD7,0x0F,0x75,0x00,0x30,0x00,0x10,0x13,0x30,0x40,0x4C,0x00,0x00,0x03,0xC4,0x11,
0x7F,0xDD,0x64,0xFF,0xFE,0x63,0x1C,0xF4,0x07,0x40,0xC0,0x34,0x40,0x03,0xC1,0x04,
0x0C,0x01,0x07,0x30,0x00,0x10,0x00,0xFD,0x11,0x67,0xFF,0xFE,0x63,0x13,0xF1,0x00,
0x10,0x00,0x30,0x00,0x10,0x13,0x30,0x10,0x13,0x00,0x30,0x00,0x10,0x00,0x30,0x63,
0x53,0xFC,0xFE,0x57,0x6F,0x33,0xF4,0x11,0x00,0x0C,0x00,0x00,0xC1,0xDD,0x34,0x04,
0x00,0x70,0x0C,0x40,0xCB,0xC0,0x8C,0x4D,0xF1,0xFB,0x1F,0x8E,0x0C,0xCC,0x38,0x04,
0x1C,0x03,0x00,0x4D,0x30,0xC1,0xC4,0x10,0x00,0x0C,0x00,0xC1,0x01,0xD3,0x63,0xB7,
0xF3,0xFE,0x04,0xDB,0x07,0x03,0x40,0x00,0x30,0x0D,0x00,0x04,0x00,0x03,0x10,0x00,
0x30,0x0D,0x04,0x00,0xC0,0x40,0x6F,0xB7,0xF7,0xFD,0x00,0xC8,0x01,0x43,0x03,0x40,
0x00,0x00,0x03,0x74,0xC0,0x0D,0x04,0x00,0x03,0x10,0x00,0x00,0x03,0x00,0xB1,0x00,
0xC0,0xF0,0x34,0xD4,0x04,0x00,0xD3,0x00,0x40,0x00,0x00,0x03,0x00,0x04,0x00,0x30,
0x00,0x04,0x00,0xC0,0x00,0x00,0x10,0x04,0x00,0xCC,0x03,0x40,0x5C,0x00,0x00,0x0C,
0x00,0x00,0x10,0x70,0x03,0x00,0x01,0x00,0x30,0x10,0x00,0x00,0xC0,0x00,0x00,0x10,
0x10,0xDC,0x7D,0x33,0x4D,0x40,0x00,0x00,0x30,0x00,0x00,0x04,0xC0,0x00,0x00,0x10,
0x00,0x00,0x37,0x00,0x01,0x00,0xC0,0x00,0x00,0x10,0x10,0xC0,0x7D,0x33,0x40,0x40,
0x00,0x00,0x30,0x00,0x00,0x04,0xC0,0x00,0x00,0x40,0x00,0x00,0xC0,0x00,0x10,0x00,
0x00,0x0C,0x00,0x00,0x01,0x31,0xDD,0x30,0x37,0x04,0x04,0x00,0xC0,0x00,0x00,0x40,
0x00,0x0C,0x00,0x00,0x04,0x00,0x00,0x0C,0x00,0x01,0x00,0xC0,0x00,0x00,0x10,0x10,
0xC7,0xDC,0x77,0x43,0x40,0x00,0x00,0x0C,0x00,0x00,0x04,0x07,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x4C,0x13,0x00,0x00,0x30,0x31,0x00,0x04,0x13,0x00,0x4C,
0x00,0x00,0x00,0x70,0x43,0x00,0x00,0xC0,0x00,0x04,0x00,0x00,0x00,0x07,0x00,0x00,
0x00,0x00,0x00,0x00,0x0C,0x10,0x13,0x00,0x00,0x00,0x00};

const unsigned char ph_P_2bitDPCM[155]= {
0x08,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x00,0x00,0x00,0x0C,0x01,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x00,0x00,
0x00,0x00,0x00,0x00,0xC0,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x04,0x0C,0x00,
0x14,0x33,0x34,0x54,0xFC,0xFD,0x54,0x70,0x30,0x13,0x4D,0xC0,0x40,0x1C,0x30,0x10,
0xC0,0x00,0x01,0x43,0x00,0x00,0x43,0x00,0x00,0x03,0x4D,0xD4,0x4F,0x7F,0x11,0x00,
0x0C,0x00,0x10,0x30,0x0D,0x10,0x03,0x40,0x30,0x10,0x00};

const unsigned char ph_R_2bitDPCM[249]= {
0x07,0x04,0x70,0x0C,0x04,0x00,0x30,0xD0,0x41,0xFD,0xF1,0x17,0x71,0xC0,0x00,0x40,
0x00,0xD3,0x40,0x0C,0x00,0x04,0x0C,0x01,0x00,0x13,0x30,0x31,0x10,0x00,0x30,0x40,
0x07,0x31,0x37,0x43,0x40,0x00,0x03,0x00,0x01,0x13,0x03,0x31,0x00,0x10,0x30,0x10,
0x00,0x30,0x01,0xD3,0x00,0x01,0x00,0x03,0x01,0xD4,0x4F,0x3F,0x05,0x04,0x0C,0x00,
0x10,0x70,0x0C,0x10,0x03,0x00,0x01,0x0C,0x10,0x00,0x0C,0x01,0xDC,0x00,0x01,0x00,
0x03,0x04,0xD4,0x73,0xFC,0x05,0x04,0x30,0x00,0x10,0x00,0x0C,0x10,0xC0,0x00,0x10,
0xC0,0x00,0x01,0x30,0x40,0x00,0x03,0x00,0x01,0x00,0x03,0x01,0xD4,0x4F,0x3F,0x05,
0x04,0x30,0x00,0x10,0x00,0x0C,0x10,0x00,0x03,0x40,0x00,0x03,0x04,0xC0,0x00,0x04,
0x30,0x00,0x04,0x00,0x30,0x10,0x40,0xF0,0xF4,0x10,0x40,0xC0,0x00,0x00,0x01,0xC0,
0x00,0x01,0x30,0x00,0x01,0x0C,0x10,0x00,0x0C,0x40,0x00,0x03,0x40,0x00,0xC0,0x00,
0x01,0xC4,0x1C,0x7F,0x01,0x04,0x0C,0x00,0x04,0x00,0x03,0x10,0x00,0x03,0x10,0xC0,
0x00,0x01,0xC0,0x00,0x04,0x30,0x00,0x04,0x00,0x0C,0x10,0x40,0xCC,0xF1,0x04,0x40,
0xC0,0x00,0x40,0x00,0x30,0x00,0x01,0x30,0x00,0x71,0xDC,0x01,0x0C,0x74,0x43,0xD3,
0xC1,0x4D,0x30,0x34,0xC4,0xC4,0x4D,0xC7,0x0D,0x31,0x74,0x37,0x01,0xDC,0x04,0xDC,
0x1D,0x70,0x77,0xC7,0x74,0xC0,0x4D,0x0C,0x1D,0xC0,0x74,0x13,0xC7,0x74,0x1C,0x77,
0x77,0xD3,0xDD,0xDD,0x4D,0xC0,0x40,0x07,0x77};

const unsigned char ph_S_2bitDPCM[205]= {
0x08,0xDC,0xC4,0x31,0x4D,0xC7,0x4D,0x70,0x37,0x31,0xDD,0xD0,0xDD,0x40,0x37,0x34,
0xDD,0x10,0x77,0x77,0xDC,0xD0,0xC1,0x74,0xC7,0x1D,0x4C,0x37,0x31,0x04,0x43,0x1C,
0xDC,0x4D,0x70,0x77,0x70,0xD3,0x71,0xD3,0xC4,0x71,0x07,0x0C,0xDD,0xDD,0x74,0xD3,
0x01,0xD3,0x31,0x71,0x37,0xDD,0x71,0xC7,0xC4,0x10,0x77,0xD3,0xDD,0xC1,0xDD,0x74,
0xD3,0x4D,0x4C,0xDC,0xC4,0x10,0xD3,0x4D,0x4C,0xC7,0xC1,0x1D,0x77,0x77,0xDC,0x04,
0xC7,0x1D,0xDC,0x40,0x07,0x77,0xC7,0xDD,0x71,0x07,0x30,0xC1,0xC4,0x1D,0x4C,0x77,
0x4C,0xDC,0x1D,0x77,0x37,0xDD,0xC1,0x1D,0x77,0x77,0x4C,0xD3,0xDD,0x4D,0x70,0x4C,
0x37,0x04,0xD3,0x4D,0x4C,0x07,0x77,0xD3,0xDD,0x31,0x0D,0x04,0x77,0xDC,0xDD,0x71,
0x77,0xD3,0x1D,0x37,0x31,0x1D,0xD3,0x1D,0xDC,0x74,0x77,0xD3,0xDD,0x31,0x1D,0xC7,
0xD0,0xDD,0x71,0x77,0x70,0xDC,0xC1,0xDD,0x1D,0x77,0xC7,0xDD,0x04,0x13,0xDC,0x71,
0x07,0xC7,0x4D,0xDC,0x31,0x4D,0x43,0x4C,0x13,0x07,0x13,0xD3,0x34,0x71,0xC7,0x71,
0x4C,0x13,0xDC,0xC4,0x71,0x37,0x4D,0xC7,0x31,0x4D,0x70,0xC7,0xC4,0xC4,0x34,0x4D,
0x1C,0x1C,0x77,0x07,0xDC,0xC4,0x34,0x31,0x4D,0x43,0xD3,0x71,0x77};

const unsigned char ph_SH_2bitDPCM[205]= {
0x07,0x34,0xDD,0xDD,0x4D,0xD3,0x71,0x77,0x1C,0xDC,0x4D,0x30,0x4D,0x1C,0xC7,0x31,
0x31,0xDD,0x34,0x71,0x1C,0x1C,0x70,0xDC,0xC4,0x71,0x77,0x4C,0x1C,0xD3,0x1D,0x77,
0xC7,0x4D,0xDC,0x71,0xD3,0xD0,0x31,0x71,0xD3,0xC4,0x1D,0x77,0x0C,0x4D,0x13,0xC7,
0x31,0x4D,0xD3,0x71,0xD3,0x74,0x4C,0xC7,0x34,0x4D,0xDC,0x74,0x77,0xD3,0x34,0x31,
0x4D,0x70,0x4C,0xD3,0x4D,0xD3,0x74,0x0C,0x71,0xDC,0x4D,0xD3,0x34,0x1D,0xC7,0x71,
0x13,0xC7,0xDD,0x71,0x37,0x31,0x4D,0x70,0x13,0xC7,0xD0,0x31,0x74,0xD3,0xC4,0x1D,
0x13,0xC7,0xD0,0xC4,0x74,0xD3,0xDD,0xDD,0x4D,0x13,0xD3,0x34,0x71,0xDC,0x40,0xD3,
0xDD,0x74,0x77,0xD3,0xD0,0x74,0x4C,0xD3,0x31,0x4D,0xD3,0x34,0xDD,0x71,0xC7,0x31,
0xDD,0x71,0x37,0x4D,0xD3,0x34,0xDD,0x74,0x1C,0x43,0x07,0xD3,0x1D,0xC7,0x71,0x4C,
0x13,0xDC,0x4D,0x4C,0x1C,0x77,0x4C,0xD3,0x74,0x70,0x1C,0xC7,0x74,0xC0,0x0D,0x01,
0x70,0x00,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x1D,0x00,
0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x71,0x00,0xC0,0x04,0x00,0x00,0x00,
0x00,0xC0,0x01,0x00,0x77,0x70,0x00,0x70,0x07,0x1C,0x77,0x70,0x00};

const unsigned char ph_T_2bitDPCM[91]= {
0x07,0x40,0xC7,0x01,0x00,0xC0,0x01,0xC0,0xC1,0xC4,0xC4,0xD0,0x01,0xD3,0x1D,0x00,
0x1C,0x4C,0xC0,0xC4,0x01,0x00,0x00,0x70,0x00,0x00,0xDC,0x04,0x07,0x00,0x00,0x00,
0x1C,0x00,0x00,0xDC,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x13,0x13,0x4C,0x43,0xC0,
0xDD,0xC1,0x31,0x04,0xC7,0x0D,0x01,0x13,0xC7,0x4D,0x4C,0x4C,0x0C,0xC1,0xD0,0xC4,
0x0D,0x71,0x13,0x77,0x1C,0x13,0x07,0x37,0xDD,0x34,0x1D,0x03,0xDD,0xC4,0x4D,0x13,
0x03,0x1D,0x37,0x1D,0x77,0x30,0x34,0xDD,0xC4,0x04,0x13};

const unsigned char ph_TH_2bitDPCM[161]= {
0x07,0xC4,0x1D,0xDC,0x4D,0x00,0x13,0xC7,0x1D,0xC7,0xD0,0xC1,0x34,0xC4,0xD0,0x04,
0x37,0x4D,0x0C,0x34,0x71,0xDC,0xC4,0xC4,0x74,0xDC,0x71,0x1C,0x77,0x30,0xDD,0x04,
0xC7,0x04,0x13,0x07,0x30,0x04,0x77,0xC7,0x4D,0xC7,0x74,0x1C,0x37,0x31,0x1D,0x37,
0xC1,0xC4,0xC4,0x01,0xC7,0x1D,0x4C,0x70,0x4C,0xC7,0x31,0x34,0xDD,0x74,0x13,0x77,
0x77,0x70,0x1C,0x37,0xC1,0x34,0xDD,0x34,0xD0,0x74,0x4C,0x00,0x4C,0x37,0xC1,0x10,
0x13,0xD3,0x1D,0xDC,0xD0,0xC1,0xC4,0x04,0xC7,0x74,0xDC,0x74,0x4C,0xC0,0x71,0x43,
0xC7,0x71,0x77,0xDC,0x34,0x4D,0x77,0xDC,0x71,0x03,0xC1,0xC4,0xC1,0x34,0xC1,0x10,
0x13,0x70,0x03,0x01,0x30,0xC4,0x00,0x11,0xCC,0x34,0x43,0x04,0x30,0xC1,0x00,0x04,
0x0C,0x00,0x00,0x01,0x00,0x30,0x10,0x00,0x43,0x0C,0x50,0xC0,0x4C,0xF3,0x54,0x00,
0x13,0x0C,0x40,0x00,0x03,0x00,0x10,0x00,0x00,0x03,0x44,0xC3,0x10,0x73,0x21,0xCC,
0xF7};

const unsigned char ph_UH_2bitDPCM[379]= {
0x08,0xC0,0xC1,0x70,0x10,0x30,0x00,0x00,0x1D,0x00,0x00,0x03,0x41,0xC3,0xC4,0x70,
0x55,0xFC,0xF7,0x4F,0x16,0x33,0xC1,0x4C,0x04,0x00,0x0C,0x10,0x0C,0x01,0x0C,0x00,
0x10,0x31,0x43,0xCC,0x94,0xF2,0x0F,0xFF,0x6B,0x3E,0x13,0x3C,0x44,0x00,0xC0,0x00,
0x01,0x03,0x01,0x0C,0x00,0x44,0x30,0x13,0xF3,0xA9,0xF0,0xCF,0xFF,0x69,0xFD,0x04,
0x0F,0x11,0x70,0xC0,0x00,0x01,0x03,0x01,0x0C,0xC4,0x10,0xF5,0x43,0xCC,0xAB,0xF6,
0xFF,0xFF,0xA7,0xF2,0x13,0xFC,0x45,0x30,0x01,0x03,0x04,0x0C,0x10,0xC0,0x40,0x0C,
0x11,0xCC,0xC4,0x7C,0x6A,0xFF,0xF7,0xFF,0x6A,0xCF,0xC1,0x43,0x04,0x43,0x30,0x40,
0x00,0x0C,0x10,0xC0,0x40,0x30,0x41,0xF0,0xD0,0x7C,0xA6,0xFC,0xF3,0xFF,0x6A,0xCF,
0xC1,0x43,0x10,0x03,0xC1,0x00,0x01,0x30,0x00,0x04,0x30,0x04,0x4C,0x10,0x3C,0x34,
0x9F,0x19,0xFF,0xFD,0xBF,0xDA,0x73,0xF0,0x10,0xC1,0x40,0x30,0x00,0x01,0x30,0x00,
0x04,0xC0,0x10,0x30,0x11,0xF0,0xC4,0xBC,0x69,0xFF,0xF7,0x3F,0x2A,0xCF,0x31,0x43,
0x04,0x03,0xC1,0x00,0x04,0xC0,0x00,0x10,0x00,0x43,0xC0,0x10,0xC1,0x4C,0xC3,0x98,
0xF1,0x0F,0xFF,0x6B,0x3E,0xD3,0x30,0x11,0x0C,0x04,0x03,0x40,0x00,0x0C,0x00,0x01,
0xC0,0x04,0x30,0x44,0x30,0xD3,0x7C,0x2A,0xFC,0xF7,0x3F,0x66,0xCF,0x31,0x43,0x04,
0x03,0xC1,0x00,0x40,0x00,0x0C,0x40,0x00,0x00,0x13,0x30,0x10,0x31,0x1C,0x33,0x95,
0xF0,0xDF,0xFC,0x98,0x0C,0xC7,0x30,0x11,0x0C,0xC4,0x00,0x00,0x10,0x00,0x03,0x10,
0x00,0x00,0x13,0xC0,0x10,0xC1,0x4C,0xC3,0x98,0xF0,0xDF,0xF3,0x58,0x31,0xC7,0x0C,
0x11,0x30,0x10,0x03,0x00,0x00,0x01,0x0C,0x40,0x00,0x70,0x00,0x00,0x0C,0x44,0x0C,
0xD3,0x70,0x55,0x3F,0x37,0x0F,0x55,0xC3,0x31,0x70,0x04,0x0C,0x00,0x10,0x0C,0x40,
0x00,0x0C,0x40,0x00,0x0C,0x01,0x00,0x0C,0x04,0x0D,0xD3,0x30,0x62,0xF3,0xC7,0x3C,
0x55,0x03,0xC0,0x70,0x04,0x0C,0x00,0x10,0x30,0x00,0x01,0x30,0x10,0x00,0xC0,0x34,
0x00,0x00,0x35,0x01,0x73,0x33,0x10,0x17,0x00,0x00,0xC7,0x00,0x00,0x01,0x13,0x03,
0x01,0x00,0x4C,0x03,0x00,0x50,0x13,0x30,0x37,0x03,0x71,0x01,0x00,0x70,0x0C,0x00,
0x10,0x30,0x31,0x04,0x00,0xC0,0x34,0x00,0x00,0xC5,0x01};

const unsigned char ph_UW_2bitDPCM[467]= {
0x08,0xFC,0xD1,0x50,0x00,0x34,0xC7,0x00,0x00,0x04,0x1C,0x03,0x04,0x00,0xC0,0x0D,
0x00,0x40,0x71,0xD0,0x1F,0x7F,0xC4,0x14,0x00,0xCD,0x31,0x00,0x00,0x01,0x30,0x00,
0x04,0x00,0xC0,0x34,0x07,0x00,0xF6,0x02,0xBF,0xFF,0xE0,0x27,0x00,0x31,0xC7,0x00,
0x00,0x04,0x00,0x03,0x40,0x00,0x00,0x4C,0x33,0x01,0x60,0x5F,0xF0,0xFB,0xDF,0x7E,
0x05,0x40,0x73,0x0C,0x00,0x40,0x00,0xC0,0x00,0x10,0x00,0x00,0x4C,0x4F,0x00,0xE8,
0x13,0xFD,0xF4,0xBF,0xBD,0x01,0xE0,0x1F,0xC3,0x01,0x10,0x00,0x30,0x00,0x10,0x00,
0x00,0x4C,0x4F,0x00,0x24,0xD3,0xCD,0xFB,0x4F,0xBD,0x01,0x10,0x1F,0x03,0x00,0x40,
0x00,0xC0,0x00,0x00,0x01,0xD0,0xC0,0xCD,0x04,0x40,0x32,0xDE,0x4F,0xFF,0xDB,0x1B,
0x00,0xF1,0x31,0x4C,0x00,0x04,0x00,0x30,0x00,0x40,0x00,0x00,0xC0,0xCD,0x04,0x80,
0x7D,0xC1,0x4C,0x3F,0xD7,0x1B,0x00,0xF1,0x31,0x00,0x00,0x04,0x00,0xC0,0x00,0x00,
0x04,0x00,0x00,0xD3,0x13,0x07,0xC9,0x38,0xFC,0xFE,0x83,0x9F,0x40,0x07,0xDF,0xC0,
0x01,0x40,0x00,0x00,0x0C,0x00,0x10,0x00,0x00,0x30,0x30,0x01,0x90,0x5F,0x37,0xEF,
0xCF,0xF5,0x15,0x00,0x0D,0x0C,0x00,0x00,0x04,0x00,0xC0,0x00,0x00,0x01,0x00,0x00,
0x0C,0x13,0x07,0xD5,0x0B,0xFC,0xFE,0x83,0x4C,0x44,0x13,0xC3,0x00,0x00,0x00,0x01,
0x00,0x30,0x00,0x40,0x00,0x00,0x00,0x03,0xD7,0x40,0xC4,0x75,0x3F,0xFE,0x5C,0x4C,
0x01,0x07,0xC0,0x00,0x00,0x00,0x01,0x00,0x30,0x00,0x00,0x04,0x00,0x00,0x30,0x00,
0x00,0x44,0x5C,0xF0,0xE3,0x3F,0xC8,0x44,0x00,0x00,0x0C,0x00,0x00,0x40,0x00,0x00,
0x30,0x00,0x00,0x01,0x00,0x00,0xC0,0x00,0x00,0x44,0x4C,0xC0,0xD3,0x0C,0xC4,0x44,
0x00,0x00,0x0C,0x00,0x00,0x00,0x01,0x00,0x30,0x00,0x00,0x04,0x00,0x00,0x00,0x03,
0xC0,0x11,0x31,0x35,0x73,0x3C,0x5C,0x13,0x01,0x00,0xC0,0x00,0x00,0x00,0x10,0x00,
0x00,0x03,0x00,0x40,0x00,0x00,0x00,0x0C,0x00,0x00,0x41,0x13,0x30,0xC7,0x0C,0xC4,
0x41,0x00,0x00,0x0C,0x00,0x00,0x00,0x01,0x30,0x00,0x01,0x03,0x10,0x00,0x00,0x00,
0x0C,0x00,0x00,0x41,0x13,0x30,0xC7,0x0C,0xC4,0x41,0x00,0x00,0x0C,0x00,0x00,0x00,
0x01,0x30,0xD0,0x1D,0xC0,0x00,0x01,0x00,0x00,0xC0,0x00,0x00,0x10,0x00,0x01,0x33,
0xCD,0x40,0x00,0x04,0x00,0x00,0x03,0x00,0x00,0x40,0x1C,0x03,0xD0,0x04,0xC0,0x31,
0x04,0x00,0x00,0xC0,0x00,0x00,0x10,0x00,0x01,0x33,0xCD,0x40,0x00,0x10,0x00,0x00,
0x0C,0x00,0x00,0x04,0x03,0x40,0x00,0x00,0x30,0x4D,0x10,0x04,0xF3,0xFD,0x10,0x10,
0x00,0x00,0x00,0x00,0x01,0x00,0x0C,0x04,0x03,0x00,0x10,0x00,0x00,0x00,0x10,0x00,
0xC0,0x30,0x0C,0x00,0x04,0x00,0x00,0x00,0x10,0x00,0x00,0x30,0x0D,0x00,0x00,0x10,
0x00,0x00,0x00};

const unsigned char ph_V_2bitDPCM[265]= {
0x09,0x1C,0x30,0x0C,0x03,0x40,0x00,0x00,0x00,0x00,0x04,0x00,0x70,0xC0,0xD0,0x00,
0x00,0x04,0x00,0x00,0x00,0x10,0x00,0x0C,0xCC,0x00,0x40,0x00,0x00,0x00,0x00,0x01,
0x00,0x00,0x07,0x03,0x00,0x00,0x04,0x00,0x00,0x00,0x04,0x00,0xC3,0xC0,0x00,0xC1,
0x01,0x00,0x00,0x40,0x00,0x00,0x00,0x4C,0x03,0x00,0x10,0x00,0x00,0x00,0x40,0x00,
0x30,0x0C,0x03,0x00,0x01,0x00,0x00,0xDD,0x01,0x07,0x1C,0x70,0x43,0x03,0xD0,0x01,
0x00,0x00,0x00,0x01,0xC0,0xC0,0x30,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x0C,
0x0D,0x00,0x00,0x01,0x00,0x00,0x00,0x04,0x00,0x0C,0xC3,0x00,0x10,0x00,0x00,0x00,
0x00,0x01,0x00,0x00,0xD3,0x00,0x00,0x04,0x07,0x00,0x00,0x04,0x00,0x30,0x0C,0x03,
0x00,0x01,0x00,0x00,0x40,0x30,0x01,0x07,0xD3,0x00,0x00,0x10,0x00,0x00,0x00,0x40,
0x00,0x30,0x30,0x03,0x00,0x01,0x00,0x10,0x43,0x30,0x01,0x1C,0x70,0x03,0x00,0x40,
0x00,0x00,0x00,0x40,0x00,0x30,0x0C,0x0C,0x00,0x04,0x00,0x00,0x00,0x04,0x1C,0xC0,
0xC4,0x00,0x00,0x01,0x00,0x00,0x00,0x10,0x00,0x30,0x0C,0x0C,0x00,0x01,0x00,0x00,
0x40,0x07,0x00,0xC0,0x10,0x0C,0x31,0x10,0x00,0x00,0x00,0x40,0x00,0xC0,0x30,0x0C,
0x00,0x01,0x00,0x00,0x00,0x74,0x00,0x1C,0xC0,0x34,0x01,0x00,0x00,0x03,0x00,0x00,
0x40,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x0C,0x00,0x00,0x01,
0x00,0x00,0x03,0x00,0x00,0x04,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x40,0x00,0x00,
0xC0,0x00,0x00,0x40,0x00,0x00,0xC0,0x00,0x00};

const unsigned char ph_W_2bitDPCM[143]= {
0x08,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x01,0x00,0x00,0x03,0x00,0x00,0x04,0x00,
0x00,0x30,0x00,0x00,0x40,0x00,0x00,0x00,0x30,0x00,0x00,0x40,0x00,0x00,0x0C,0x00,
0x00,0x04,0x30,0x00,0x04,0x00,0x00,0x0C,0x00,0x40,0x00,0x01,0xCC,0x0C,0x40,0x40,
0x40,0x03,0x03,0x00,0x40,0x00,0x00,0x03,0x00,0x04,0x00,0x00,0x0C,0x00,0x10,0x04,
0xC0,0x3C,0x00,0x41,0x00,0x00,0x03,0x00,0x10,0x00,0x0C,0x04,0x30,0x00,0x00,0x41,
0xCC,0x00,0x00,0x54,0x30,0xF3,0x0C,0x15,0x0D,0xC0,0x4C,0x04,0x00,0xC0,0x00,0x04,
0x00,0x00,0x00,0x0C,0x00,0x00,0x10,0x00,0x00,0xC0,0x31,0x00,0x00,0x4D,0x07,0x00,
0x00,0x37,0x00,0x00,0x10,0x00,0x00,0x30,0x0D,0x00,0x40,0xD3,0x01,0x00,0xC0,0x0D,
0x00,0x00,0x10,0x07,0x00,0x00,0x70,0x0C,0x00,0x4D,0x77,0x4C,0x03,0x00,0x00};

const unsigned char ph_Y_2bitDPCM[207]= {
0x08,0x00,0x00,0xC0,0x4D,0x03,0x00,0x40,0x77,0x00,0x00,0x00,0x00,0x00,0x4C,0x03,
0x00,0x00,0x00,0x40,0xC7,0x01,0x00,0x00,0xDC,0x34,0x00,0x00,0x74,0x00,0x00,0x00,
0x00,0x07,0xC7,0xC4,0xD0,0x34,0x00,0x00,0x40,0x1C,0x00,0x00,0xD0,0x70,0x03,0x00,
0x4D,0x07,0x00,0x00,0xC0,0x0D,0x71,0x37,0x1D,0x4C,0xD3,0x00,0x00,0xC4,0x01,0x00,
0x00,0x1C,0x37,0x00,0xD0,0x74,0x00,0x00,0x70,0xDC,0xD0,0x74,0xC7,0xC1,0x71,0x03,
0x00,0x40,0xC7,0x01,0x00,0xFB,0x3E,0x00,0x00,0x1D,0x07,0x00,0xC0,0x31,0x0D,0x40,
0x13,0x00,0xC7,0x0D,0x00,0x00,0x1D,0x07,0x00,0xEC,0xFB,0x0D,0x00,0x74,0x1C,0x00,
0x00,0x03,0x00,0x00,0x10,0x00,0x00,0x70,0x03,0x00,0x40,0x1C,0x40,0x4C,0xEF,0xC3,
0x04,0xD0,0x04,0x00,0x0C,0x00,0x00,0x40,0x1C,0x13,0x00,0x00,0x00,0x37,0x00,0x4D,
0x00,0x31,0x7D,0x1F,0x13,0x40,0x1C,0x00,0x03,0x00,0x10,0x00,0xC0,0x00,0x00,0x71,
0x00,0x30,0xD0,0x00,0x40,0x07,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0xD0,0x1D,
0x00,0x77,0x70,0x43,0x70,0x37,0xC1,0xDD,0x4D,0x13,0x00,0x00,0x00,0x00,0xC0,0x00,
0x00,0x00,0x00,0x40,0x1C,0x00,0x43,0x37,0x74,0xD3,0x01,0xDC,0x0D,0xDD,0x01};

const unsigned char ph_Z_2bitDPCM[221]= {
0x08,0x00,0x00,0x00,0x0C,0x00,0x00,0x00,0x40,0x77,0x00,0x77,0xC7,0x1D,0x30,0x71,
0x37,0xD0,0x00,0x10,0x00,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x00,0x74,0x07,0x00,
0x77,0xD3,0xDD,0x01,0x00,0x37,0x0D,0x10,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x00,
0x00,0x00,0x01,0x00,0x70,0x37,0xDD,0xC1,0x71,0x37,0x00,0x40,0x00,0x00,0x00,0x00,
0x00,0x0C,0x00,0x00,0x00,0x00,0x04,0x00,0xC0,0x34,0x0D,0xDD,0xC1,0x4D,0x03,0x00,
0x01,0x00,0x00,0x00,0x00,0x0C,0x00,0x00,0x00,0x00,0x1D,0x00,0x70,0x03,0xD0,0x01,
0x00,0x70,0xD3,0x00,0x40,0x00,0x00,0x00,0x00,0x0C,0x00,0x00,0x00,0x10,0x00,0xC0,
0x31,0x34,0x74,0x13,0x1C,0xC0,0xC1,0x00,0x00,0x01,0x00,0x00,0x00,0x03,0x00,0x00,
0x00,0x04,0x00,0x0C,0x00,0xD0,0x74,0x07,0x00,0x00,0xC0,0x00,0x00,0x71,0x00,0x40,
0x03,0xCC,0x10,0x00,0x71,0x00,0x00,0x03,0x00,0xDD,0x74,0x03,0x10,0x00,0xC0,0xD0,
0x00,0x00,0x35,0x01,0x73,0x33,0x10,0x17,0x00,0x00,0xC7,0x00,0x00,0x71,0xD3,0x4D,
0x00,0x00,0x00,0x03,0x00,0xD0,0x74,0xC0,0x74,0x37,0x4D,0x1C,0xC7,0x31,0x4D,0x13,
0xC7,0x4D,0x07,0x00,0x00,0x30,0x00,0x00,0xD0,0x71,0x43,0xD3,0x34,0x1D,0xDC,0xC4,
0x71,0xC0,0xDD,0x74,0x70,0x00,0x00,0x00,0x03,0x00,0x00,0x4D,0x13};

const unsigned char ph_ZH_2bitDPCM[135]= {
0x08,0xDC,0x4D,0x13,0xD3,0x4D,0x07,0xDC,0xC1,0x74,0xC0,0x1D,0x00,0xC0,0x00,0x00,
0xD0,0xC1,0x4D,0xD3,0x71,0x13,0xC7,0x1D,0xD3,0xC4,0x71,0xC7,0xDD,0x01,0x00,0x00,
0xDC,0x00,0x00,0xD0,0x31,0x4D,0xD3,0x34,0x71,0x1C,0xDC,0x74,0x13,0xDC,0x71,0x37,
0x1D,0x00,0x00,0x30,0x0D,0x00,0xC4,0x71,0x77,0x03,0x4D,0x77,0x4C,0xD3,0xDD,0x71,
0x1C,0xDC,0x71,0xD3,0xC1,0x71,0x00,0xDC,0x00,0x00,0x74,0xC7,0xDD,0x1D,0x07,0x77,
0xDC,0x1D,0x37,0x71,0x1C,0x77,0x1C,0x77,0x00,0x00,0x00,0x03,0x00,0xD0,0x4D,0x77,
0xD3,0xD0,0x4D,0x77,0xC7,0x31,0x1D,0xD3,0x74,0x1C,0x4C,0x13,0x77,0x1C,0xC7,0x71,
0x0C,0x40,0xC7,0xC1,0xDD,0x40,0x37,0xC1,0x1D,0x37,0x34,0x1D,0x77,0xC7,0x31,0x71,
0x13,0x00,0x00,0x0C,0x00,0xB0,0xBB};

/*
 * Lookup table sample start.
 */
const unsigned int phonemes[39] = {
0,
427,
818,
1251,
1654,
2215,
2776,
2935,
3112,
3271,
3424,
3805,
4318,
4855,
5060,
5221,
5342,
5551,
6004,
6121,
6216,
6441,
6632,
6877,
7170,
7735,
8338,
8493,
8742,
8947,
9152,
9243,
9404,
9783,
10250,
10515,
10658,
10865,
11086,
};

/*
 * Lookup table sample length
 */
const unsigned int phoneme_lengths[39] = {
427,
391,
433,
403,
561,
561,
159,
177,
159,
153,
381,
513,
537,
205,
161,
121,
209,
453,
117,
95,
225,
191,
245,
293,
565,
603,
155,
249,
205,
205,
91,
161,
379,
467,
265,
143,
207,
221,
135,
};

#endif
